package com.biz.crm.sfa.business.visit.plan.sdk.vo;

import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Entity;

/**
 * 拜访计划明细客户vo
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@ApiModel(value = "VisitPlanDetailClientVo", description = "拜访计划明细客户vo")
public class VisitPlanDetailClientVo {

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  private String clientRoute;

  /**
   * 客户细类
   */
  @ApiModelProperty("客户细类")
  private String clientSubName;

  /**
   * 客户地址
   */
  @ApiModelProperty("客户地址")
  private String clientAddress;

}
