package com.biz.crm.sfa.business.visit.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.FileVo;
import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @description: 拜访计划异常明细表
 * @author: rentao
 * @date: 2022/7/5 19:48
 */
@Data
@ApiModel(value = "VisitPlanDetailExceptionVo", description = "拜访计划异常明细表")
public class VisitPlanDetailExceptionVo extends UuidOpVo {

  private static final long serialVersionUID = 9073271329891194305L;
  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  private String clientRoute;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 异常信息
   */
  @ApiModelProperty("异常信息")
  private String remark;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String visitRealName;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  private String visitUserName;
  /**
   * 人员职位编码
   */
  @ApiModelProperty("人员职位编码")
  private String visitPostCode;

  /**
   * 人员职位名称
   */
  @ApiModelProperty("人员职位名称")
  private String visitPostName;

  /**
   * 人员所属组织编码
   */
  @ApiModelProperty("人员所属组织编码")
  private String visitOrgCode;

  /**
   * 人员所属组织名称
   */
  @ApiModelProperty("人员所属组织名称")
  private String visitOrgName;


  @ApiModelProperty("文件")
  private List<FileVo> fileVoList;

}
