package com.biz.crm.sfa.business.visit.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import com.biz.crm.sfa.business.client.sdk.vo.ClientContactVo;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitPlanTypeEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Entity;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 拜访计划明细 实体类
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@ApiModel(value = "VisitPlanDetail", description = "拜访计划明细表")
public class VisitPlanDetailVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 7022214277071025864L;
  /**
   * 拜访计划编码
   */
  @ApiModelProperty("拜访计划编码")
  private String visitPlanCode;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  private String visitUserName;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String visitRealName;

  /**
   * 人员职位编码
   */
  @ApiModelProperty("人员职位编码")
  private String visitPostCode;

  /**
   * 人员职位名称
   */
  @ApiModelProperty("人员职位名称")
  private String visitPostName;

  /**
   * 人员所属组织编码
   */
  @ApiModelProperty("人员所属组织编码")
  private String visitOrgCode;

  /**
   * 人员所属组织名称
   */
  @ApiModelProperty("人员所属组织名称")
  private String visitOrgName;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  private String clientRoute;

  /**
   * 客户细类
   */
  @ApiModelProperty("客户细类")
  private String clientSubName;

  /**
   * 拜访状态
   * {@link VisitStatusEnum#getDictCode()}
   */
  @ApiModelProperty("拜访状态")
  private String visitStatus;

  /**
   * 拜访类型  临时拜访-计划外，计划拜访-计划内
   * <p>
   * {@link VisitPlanTypeEnum#getDictCode()}
   */
  @ApiModelProperty("拜访计划类型")
  private String visitPlanType;

  /**
   * 拜访日期
   */
  @ApiModelProperty("拜访日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date visitDate;

  /**
   * 拜访开始时间
   */
  @ApiModelProperty("拜访开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date visitStartDate;

  /**
   * 拜访结束时间
   */
  @ApiModelProperty("拜访结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date visitEndDate;
  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private BigDecimal latitude;

  /**
   * 客户地址
   */
  @ApiModelProperty("客户地址")
  private String clientAddress;

  /**
   * 联系人列表
   */
  @ApiModelProperty("联系人列表")
  private List<ClientContactVo> contactList;

}
