package com.biz.crm.sfa.business.visit.plan.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 拜访计划异常报表查询dto
 * @author: rentao
 * @date: 2022/7/5 19:48
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "VisitPlanDetailExceptionQueryDto", description = "拜访计划异常报表查询dto")
public class VisitPlanDetailExceptionQueryDto {

  @ApiModelProperty("租户编码")
  private String tenantCode;

  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date startCreateTime;

  /**
   * 结束时间
   */
  @ApiModelProperty(name = "createTime", value = "结束时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date endCreateTime;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户类型
   */
  @ApiModelProperty("客户类型")
  private String clientType;


  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String visitRealName;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  private String visitUserName;

  /**
   * 客户名称
   *
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 人员职位编码
   */
  @ApiModelProperty("人员职位编码")
  private String visitPostCode;

  /**
   * 人员职位名称
   */
  @ApiModelProperty("人员职位名称")
  private String visitPostName;

  /**
   * 人员所属组织编码
   */
  @ApiModelProperty("人员所属组织编码")
  private String visitOrgCode;

  /**
   * 人员所属组织名称
   */
  @ApiModelProperty("人员所属组织名称")
  private String visitOrgName;
}
