package com.biz.crm.sfa.business.visit.plan.sdk.event;

import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 拜访计划制定日志
 *
 * @author songjingen
 */
public interface VisitPlanLogEventListener extends NebulaEvent {

  /**
   * 创建事件
   *
   * @param eventDto
   */
  void onCreate(VisitPlanEventDto eventDto);


  /**
   * 更新日志
   *
   * @param eventDto
   */
  void onUpdate(VisitPlanEventDto eventDto);

  /**
   * 启用
   *
   * @param eventDto
   */
  void onEnable(VisitPlanEventDto eventDto);

  /**
   * 禁用
   *
   * @param eventDto
   */
  void onDisable(VisitPlanEventDto eventDto);

  /**
   * 手动刷新
   *
   * @param eventDto
   */
  void onRefresh(VisitPlanEventDto eventDto);

  /**
   * 删除
   *
   * @param eventDto
   */
  void onDelete(VisitPlanEventDto eventDto);
}
