package com.biz.crm.sfa.business.visit.plan.sdk.observer;

import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanDetailModel;

import java.util.List;
import java.util.Map;

/**
 * 拜访计划明细观察者，上层所有维度有需要实现此观察者
 *
 * @author songjingen
 */
public interface VisitPlanDetailObserver {

  /**
   * 通过拜访计划编码请求拜访计划明细数据集合
   *
   * @param map key-拜访计划维度，value-拜访计划编码集合
   * @return 拜访计划明细数据
   */
  List<VisitPlanDetailModel> onRequestVisitDetailDto(Map<String, List<String>> map);

  /**
   * 创建计划明细信息
   *
   * @param map key-拜访计划维度，value-拜访计划编码集合
   */
  void onCreate(Map<String, List<String>> map);

  /**
   * 更新计划明细信息
   *
   * @param map key-拜访计划维度，value-拜访计划编码集合
   */
  void onUpdate(Map<String, List<String>> map);

}
