package com.biz.crm.sfa.business.visit.plan.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailDto;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanDetailModel;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 拜访计划明细(VisitPlanDetailVo)服务接口
 *
 * @author songjingen
 * @since 2022-05-13 13:59:26
 */
public interface VisitPlanDetailVoService {

  /**
   * 根据拜访计划编码集合批量新增数据
   *
   * @param visitPlanDetailDtos 创建dto
   * @return 新增结果
   */
  void createBatchByVisitPlanDetailDto(List<VisitPlanDetailDto> visitPlanDetailDtos);

  /**
   * 根据拜访计划编码集合批量修改新据
   *
   * @param visitPlanDetailDtos 创建dto
   * @return 修改结果
   */
  void updateBatchByVisitPlanDetailDto(List<VisitPlanDetailDto> visitPlanDetailDtos);

  /**
   * 批量新增数据
   *
   * @param dto 实体对象
   * @return 新增结果
   */
  void createBatch(List<VisitPlanDetailModel> dto);

  /**
   * 批量修改新据
   *
   * @param dto 实体对象
   * @return 修改结果
   */
  void updateBatch(List<VisitPlanDetailModel> dto);


  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  Page<VisitPlanDetailVo> findByConditions(Pageable pageable, VisitPlanDetailQueryDto dto);

  /**
   * 按照条件查询数据不带分页
   *
   * @param dto 实体对象
   * @return
   */
  List<VisitPlanDetailVo> findByConditions(VisitPlanDetailQueryDto dto);
}

