package com.biz.crm.sfa.business.visit.plan.sdk.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.visit.plan.sdk.abstracts.VisitPlanRouteRangeAbstract;
import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanRouteRangeModel;
import com.biz.crm.sfa.business.visit.plan.sdk.register.VisitPlanRouteRegister;

/**
 * 拜访计划维度策略
 *
 * @author songjingen
 */
public interface VisitPlanRouteStrategy {

  /**
   * 维度key
   * {@link VisitPlanRouteRegister#getKey()}
   *
   * @return
   */
  String getKey();

  /**
   * 此方法在拜访计划创建成功后进行触发
   * 该json对象：{
   * "@某个routeKey":{},
   * "@某个routeKey":{},
   * }
   *
   * @param jsonObject json对象
   */
  default VisitPlanRouteRangeModel onCreate(JSONObject jsonObject) {
    return null;
  }

  /**
   * 此方法在拜访计划修改成功后进行触发
   * 该json对象：{
   * "@某个routeKey":{},
   * "@某个routeKey":{},
   * }
   *
   * @param jsonObject json对象
   */
  default VisitPlanRouteRangeModel onUpdate(JSONObject jsonObject) {
    return null;
  }

  /**
   * 根据拜访计划编码查询数据
   *
   * @param visitPlanCode 拜访计划编码
   * @return 拜访计划维度拜访信息
   */
  default VisitPlanRouteRangeAbstract onFindRouteRange(String visitPlanCode) {
    return null;
  }

}
