package com.biz.crm.sfa.business.work.task.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskObject;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskObjectService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReportDto;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: some desc
 * @author: rentao
 * @date: 2022/6/14 9:58
 */
@RestController
@RequestMapping("/v1/workTask/workTaskObject")
@Slf4j
@Api(tags = "工作计划执行对象:WorkTaskReportVo:工作计划执行对象")
public class WorkTaskObjectController {


  @Autowired
  private WorkTaskObjectService workTaskObjectService;
  /**
   * 工作计划执行对象分页
   *
   * @param pageable 分页信息
   * @param workTaskObject      参数Dto
   * @return 工作计划执行对象分页
   */
  @ApiOperation(value = "工作计划执行对象分页")
  @GetMapping("/findByConditions")
  public Result<Page<WorkTaskObject>> findByConditions(@PageableDefault(50) Pageable pageable,
      @ApiParam(name = "workTaskObject", value = "分页Dto") WorkTaskObject workTaskObject) {
    try {
      return Result.ok(this.workTaskObjectService.findByConditions(pageable, workTaskObject));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
