package com.biz.crm.sfa.business.work.task.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskReceve;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskReceveService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import oracle.jdbc.proxy.annotation.Post;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @description: 工作计划接收执行 controller
 * @author: rentao
 * @date: 2022/6/15 13:54
 */
@RestController
@RequestMapping("/v1/workTask/workTaskReceve")
@Slf4j
@Api(tags = "工作计划接收执行:workTaskReceve:工作计划接收执行")
public class WorkTaskReceveController {

  @Autowired
  private WorkTaskReceveService workTaskReceveService;

  /**
   * 修改
   *
   * @param workTaskReceveDto 修改参数
   *
   */
  @ApiOperation(value = "修改")
  @PatchMapping
  public Result<WorkTaskReceve> update(@ApiParam(name = "workTaskReceveDto", value = "工作计划接收执行") @RequestBody WorkTaskReceveDto workTaskReceveDto) {
    try {
      WorkTaskReceve result = this.workTaskReceveService.update(workTaskReceveDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改
   *
   * @param workTaskReceveDto 修改参数
   *
   */
  @ApiOperation(value = "修改")
  @PostMapping("updateTurnPatch")
  public Result<WorkTaskReceve> updateTurnPatch(@ApiParam(name = "workTaskReceveDto", value = "工作计划接收执行") @RequestBody WorkTaskReceveDto workTaskReceveDto) {
    try {
      WorkTaskReceve result = this.workTaskReceveService.update(workTaskReceveDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
