package com.biz.crm.sfa.business.work.task.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTask;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReportDto;
import com.biz.crm.sfa.business.work.task.sdk.service.WorkTaskReportVoService;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;


/**
 * 工作任务-报表(WorkTaskReportVo)
 *
 * @author rentao
 * @since 2022-06-13 14:05:00
 */
@RestController
@RequestMapping("/v1/workTask/workTaskReport")
@Slf4j
@Api(tags = "工作任务报表:WorkTaskReportVo:工作任务报表")
public class WorkTaskReportController {

  @Autowired
  private WorkTaskReportVoService workTaskReportVoService;

  /**
   * 查询工作任务报表
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 查询工作任务报表
   */
  @ApiOperation(value = "查询工作任务报表")
  @GetMapping("/findByConditions")
  public Result<Page<WorkTaskReportVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      @ApiParam(name = "WorkTaskReportDto", value = "分页Dto") WorkTaskReportDto dto) {
    try {
      return Result.ok(this.workTaskReportVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * id查询
   *
   * @param id 主键
   *
   */
  @ApiOperation(value = "id查询")
  @GetMapping("{id}")
  public Result<WorkTaskReportVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      WorkTaskReportVo workTaskReportVo = this.workTaskReportVoService.findById(id);
      return Result.ok(workTaskReportVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
