package com.biz.crm.sfa.business.work.task.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskQueryDto;
import com.biz.crm.sfa.business.work.task.sdk.service.WorkTaskVoService;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 工作计划发布表 controller
 * @author: rentao
 * @date: 2022/6/15 14:20
 */
@RestController
@RequestMapping("/v1/workTask/workTask")
@Slf4j
@Api(tags = "工作计划发布表:WorkTaskVo:工作计划发布表")
public class WorkTaskVoController {

  @Autowired private WorkTaskVoService workTaskVoService;
  /**
   * 分页查询（登录人）工作任务接收
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 查询工作任务报表
   */
  @ApiOperation(value = "分页查询（登录人）工作任务接收")
  @GetMapping("/findByConditions")
  public Result<Page<WorkTaskVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      @ApiParam(name = "WorkTaskQueryDto", value = "分页Dto") WorkTaskQueryDto dto) {
    try {
      return Result.ok(this.workTaskVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * id查询
   *
   * @param id 主键
   *
   */
  @ApiOperation(value = "id查询")
  @GetMapping("{id}")
  public Result<WorkTaskVo> findDetailById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      WorkTaskVo workTaskVo = this.workTaskVoService.findDetailById(id);
      return Result.ok(workTaskVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
