package com.biz.crm.sfa.business.work.task.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 工作任务-执行对象
 * @author: rentao
 * @date: 2022/6/13 14:21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_work_task_object")
@Table(name = "sfa_work_task_object", indexes = {
    @Index(name = "sfa_work_task_object_index1", columnList = "task_id"),
})
@ApiModel(value = "WorkTaskObject", description = "工作任务-执行对象")
@org.hibernate.annotations.Table(appliesTo = "sfa_work_task_object", comment = "工作任务(发布)")
public class WorkTaskObject extends TenantFlagOpEntity {

  /**
   * 工作任务id
   */
  @ApiModelProperty("工作任务id")
  @Column(name = "task_id", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '工作任务id'")
  private String taskId;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '客户编码'")
  private String customerCode;

  /**
   * 客户类型
   */
  @ApiModelProperty("客户类型")
  @Column(name = "customer_type", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '客户类型'")
  private String customerType;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @Column(name = "customer_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '客户名称'")
  private String customerName;
}
