package com.biz.crm.sfa.business.work.task.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskObject;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 工作任务-执行对象(WorkTaskObject)mybatismapper
 *
 * @author rentao
 * @since 2022-06-13 14:05:00
 */
public interface WorkTaskObjectMapper extends BaseMapper<WorkTaskObject> {

  /**
   * 分页查询
   *
   * @param page 分页参数
   * @param workTaskObject 分页条件
   */
   Page<WorkTaskObject> findByConditions(
      @Param("page") Page<WorkTaskObject> page,
      @Param("dto") WorkTaskObject workTaskObject);

  /**
   * 条件查询
   *
   * @param workTaskObject 分页条件
   */
   List<WorkTaskObject> findByConditions(@Param("dto") WorkTaskObject workTaskObject);
}
