package com.biz.crm.sfa.business.work.task.local.repository;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskReceve;
import com.biz.crm.sfa.business.work.task.local.mapper.WorkTaskReceveMapper;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveQueryDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReportDto;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReceveVo;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 工作计划发布表(WorkTaskReceve)Repository
 *
 * @author rentao
 * @since 2022-06-13 14:05:00
 */
@Component
public class WorkTaskReceveRepository extends ServiceImpl<WorkTaskReceveMapper, WorkTaskReceve> {

  @Autowired private WorkTaskReceveMapper workTaskReceveMapper;

  /**
   * 分页查询
   *
   * @param pageable 分页参数
   * @param workTaskReceveDto 分页条件
   */
  public Page<WorkTaskReceve> findByConditions(Pageable pageable, WorkTaskReceveDto workTaskReceveDto) {
    Page<WorkTaskReceve> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<WorkTaskReceve> pageList =
        this.workTaskReceveMapper.findByConditions(page, workTaskReceveDto);
    return pageList;
  }

  /**
   * 分页查询
   *
   * @param pageable 分页参数
   * @param workTaskReceveQueryDto 分页条件
   */
  public Page<WorkTaskReceveVo> findVoByConditions(Pageable pageable, WorkTaskReceveQueryDto workTaskReceveQueryDto) {
    Page<WorkTaskReceveVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<WorkTaskReceveVo> pageList =
        this.workTaskReceveMapper.findVoByConditions(page, workTaskReceveQueryDto);
    return pageList;
  }

  /**
   * 分页查询
   *
   * @param pageable 分页参数
   * @param WorkTaskReportDto 分页条件
   */
  public  Page<WorkTaskReportVo> findSfaWorkTaskReportList(Pageable pageable, WorkTaskReportDto WorkTaskReportDto) {
    Page<WorkTaskReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<WorkTaskReportVo> pageList =
        this.workTaskReceveMapper.findSfaWorkTaskReportList(page, WorkTaskReportDto);
    return pageList;
  }

  /**
   * 条件查询不分页
   * @param
   * @return
   */
  public List<WorkTaskReceve> findByConditions(WorkTaskReceveDto workTaskReceveDto){
    return this.workTaskReceveMapper.findByConditions(workTaskReceveDto);
  }

  /**
   * id查询详情
   * @param
   * @return
   */
  public WorkTaskReceveVo findDetailById(String id){
    return this.workTaskReceveMapper.findDetailById(id);
  }

  /**
   * taskid批量查询
   * @param
   * @return
   */
  public List<WorkTaskReceve> findByTaskIds(Set<String> ids){
   return this.lambdaQuery().in(WorkTaskReceve::getTaskId,ids)
        .eq(WorkTaskReceve::getTenantCode,TenantUtils.getTenantCode())
        .eq(WorkTaskReceve::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .list();
  }


  public Page<WorkTaskReceveVo> findDayPlan(Pageable pageable, WorkTaskReceveQueryDto workTaskReceveQueryDto){
    Page<WorkTaskReceveVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<WorkTaskReceveVo> pageList =
        this.workTaskReceveMapper.findDayPlan(page, workTaskReceveQueryDto);
    return pageList;
  }


  public List<WorkTaskReceveVo> findDayPlanList(WorkTaskReceveQueryDto workTaskReceveQueryDto){
    List<WorkTaskReceveVo> pageList = this.workTaskReceveMapper.findDayPlan(workTaskReceveQueryDto);
    return pageList;
  }
}


