package com.biz.crm.sfa.business.work.task.local.repository;

import com.biz.crm.sfa.business.work.task.local.entity.WorkTask;
import com.biz.crm.sfa.business.work.task.local.mapper.WorkTaskMapper;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskQueryDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveQueryDto;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReceveVo;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskVo;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import java.util.List;

/**
 * 工作计划发布表(WorkTask)Repository
 *
 * @author rentao
 * @since 2022-06-13 14:04:56
 */
@Component
public class WorkTaskRepository extends ServiceImpl<WorkTaskMapper, WorkTask> {

  @Autowired
  private WorkTaskMapper workTaskMapper;

  /**
   * 分页查询
   *
   * @param pageable 分页参数
   * @param workTask 分页条件
   */
  public Page<WorkTask> findByConditions(Pageable pageable, WorkTask workTask) {
    Page<WorkTask> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<WorkTask> pageList = this.workTaskMapper.findByConditions(page, workTask);
    return pageList;
  }

  /**
   * 编辑进度和状态
   *
   * @param workTaskDto 状态对象
   * @return
   */
  public void updateProgressAndTaskStatusById(WorkTaskDto workTaskDto) {
    this.lambdaUpdate()
            .eq(WorkTask::getId, workTaskDto.getId())
            .set(WorkTask::getProgress, workTaskDto.getProgress())
            .set(WorkTask::getTaskStatus, workTaskDto.getTaskStatus())
            .update();
  }

  /**
   * 分页查询
   *
   * @param pageable 分页参数
   * @param workTaskQueryDto 分页条件
   */
  public Page<WorkTaskVo> findVoByConditions(Pageable pageable, WorkTaskQueryDto workTaskQueryDto) {
    Page<WorkTaskVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<WorkTaskVo> pageList =
        this.workTaskMapper.findVoByConditions(page, workTaskQueryDto);
    return pageList;
  }
}

