package com.biz.crm.sfa.business.work.task.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskReceve;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveDto;
import java.util.Date;
import java.util.Set;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 工作计划接收表(WorkTaskReceve)service
 *
 * @author rentao
 * @since 2022-06-13 14:05:00
 */
public interface WorkTaskReceveService{

  /**
   * 新增
   *
   * @param workTaskReceveDtos 新增参数
   *
   */
  void createBatch(List<WorkTaskReceveDto> workTaskReceveDtos);

  /**
   * 编辑
   *
   * @param workTaskReceveDto 编辑参数
   *
   */
  WorkTaskReceve update(WorkTaskReceveDto workTaskReceveDto);


  /**
   * 任务定时过期策略
   * @param
   */
  void timeExpiredTask();

  /**
   * 条件查询部分也
   *
   * @param workTaskReceveDto
   *
   */
  List<WorkTaskReceve> findByConditions(WorkTaskReceveDto workTaskReceveDto);

  /**
   * 任务id查询 具体接收任务
   *
   * @param ids 新增参数
   *
   */
  List<WorkTaskReceve> findByTaskIds(Set<String> ids);

}

