package com.biz.crm.sfa.business.work.task.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTask;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskObject;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskPicture;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskReceve;
import com.biz.crm.sfa.business.work.task.local.repository.WorkTaskReceveRepository;
import com.biz.crm.sfa.business.work.task.local.repository.WorkTaskRepository;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskObjectService;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskPictureService;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskReceveService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskPictureDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskQueryDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveQueryDto;
import com.biz.crm.sfa.business.work.task.sdk.enums.AttachmentBizTypeEnum;
import com.biz.crm.sfa.business.work.task.sdk.enums.SfaTaskStatusEnum;
import com.biz.crm.sfa.business.work.task.sdk.service.WorkTaskReceveVoService;
import com.biz.crm.sfa.business.work.task.sdk.service.WorkTaskVoService;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskPictureVo;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReceveVo;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javafx.scene.effect.SepiaTone;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @description: 工作任务发布vo service
 * @author: rentao
 * @date: 2022/6/15 10:38
 */
@Service
@Slf4j
public class WorkTaskVoServiceImpl implements WorkTaskVoService {

  @Autowired private LoginUserService loginUserService;
  @Autowired private WorkTaskRepository workTaskRepository;
  @Autowired private WorkTaskPictureService workTaskPictureService;
  @Autowired private WorkTaskObjectService workTaskObjectService;
  @Autowired private WorkTaskReceveService workTaskReceveService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 分页查询(任务接收接口) 查询登录人当前组织岗位下
   *
   * @param pageable 分页参数
   * @param workTaskQueryDto 分页条件
   */
  @Override
  public Page<WorkTaskVo> findByConditions(Pageable pageable, WorkTaskQueryDto workTaskQueryDto) {
    LoginUserDetails loginDetails = loginUserService.getLoginDetails(LoginUserDetails.class);
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(workTaskQueryDto)) {
      workTaskQueryDto = new WorkTaskQueryDto();
    }
    workTaskQueryDto.setCreateOrgCode(loginDetails.getOrgCode());
    workTaskQueryDto.setCreatePosCode(loginDetails.getPostCode());
    workTaskQueryDto.setCreateAccount(loginDetails.getAccount());
    Page<WorkTaskVo> workTaskVoPage = this.workTaskRepository.findVoByConditions(pageable, workTaskQueryDto);
    //百分比进度条
    this.transitionPageData(workTaskVoPage.getRecords());
    return workTaskVoPage;
  }

  @Override
  public WorkTaskVo findDetailById(String id) {
    WorkTask workTask = this.workTaskRepository.getById(id);
    if (Objects.nonNull(workTask)) {
      WorkTaskVo workTaskVo = this.nebulaToolkitService.copyObjectByBlankList(workTask, WorkTaskVo.class, HashSet.class, ArrayList.class);
      // 发布照片发布对象
      this.transitionData(workTaskVo);
      //执行人
      this.transitionDetailData(workTaskVo);
      return workTaskVo;
    }
    return null;
  }

  /**
   * 计算百分比
   *
   * @param molecule 分子
   * @param denominator 分母
   * @return
   */
  private String getPercentage(Integer molecule, Integer denominator) {
    NumberFormat numberFormat = NumberFormat.getInstance();
    numberFormat.setMaximumFractionDigits(2);
    return numberFormat.format((float) molecule / (float) denominator * 100);
  }

  /**
   * 转换数据
   *
   * @param workTaskVos 需要转换的数据
   * @return
   */
  private void transitionPageData(List<WorkTaskVo> workTaskVos) {
    if (!CollectionUtils.isEmpty(workTaskVos)) {
      // 百分比进度条
      Set<String> setTaskId = new HashSet<>();
      workTaskVos.forEach(
          workTaskVo -> {
            String progress = workTaskVo.getProgress();
            String[] split = progress.split("/");
            workTaskVo.setQuantityNum(split[0]);
            workTaskVo.setSumAll(split[1]);
            // 如果执行任务总人数为1
            if ("1".equals(split[1])) {
              setTaskId.add(workTaskVo.getId());
            }
            workTaskVo.setProgress(
                this.getPercentage(Integer.valueOf(split[0]), Integer.valueOf(split[1])));
          });
      if (!CollectionUtils.isEmpty(setTaskId)) {
        List<WorkTaskReceve> workTaskReceves = this.workTaskReceveService.findByTaskIds(setTaskId);
        if (!CollectionUtils.isEmpty(workTaskReceves)) {
          Map<String, WorkTaskReceve> workTaskReceveMap =
              workTaskReceves.stream().collect(Collectors.toMap(WorkTaskReceve::getTaskId, a -> a));
          workTaskVos.forEach(
              workTaskVo -> {
                WorkTaskReceve workTaskReceve = workTaskReceveMap.get(workTaskVo.getId());
                if (Objects.nonNull(workTaskReceve)) {
                  workTaskVo.setExecutor(workTaskReceve.getReceverName());
                }
              });
        }
      }
    }
  }


  /**
   * 转换数据
   *
   * @param workTaskVo 需要转换的数据
   * @return
   */
  private void transitionData(WorkTaskVo workTaskVo) {
    // 发布照片发布对象
    WorkTaskPictureDto workTaskPictureDto = new WorkTaskPictureDto();
    workTaskPictureDto.setTaskIds(Collections.singletonList(workTaskVo.getId()));
    workTaskPictureDto.setTaskType(AttachmentBizTypeEnum.TASK_ADD.getDictCode());
    List<WorkTaskPicture> workTaskPictures = this.workTaskPictureService.findList(workTaskPictureDto);
    if(!CollectionUtils.isEmpty(workTaskPictures)){
      List<WorkTaskPictureVo> list = (List<WorkTaskPictureVo>) this.nebulaToolkitService.copyCollectionByBlankList(workTaskPictures
          , WorkTaskPicture.class, WorkTaskPictureVo.class, HashSet.class, ArrayList.class);
      workTaskVo.setSendTaskPicList(list);
    }
    WorkTaskObject workTaskObject = new WorkTaskObject();
    workTaskObject.setTaskId(workTaskVo.getId());
    List<WorkTaskObject> workTaskObjects = this.workTaskObjectService.findList(workTaskObject);
    if(!CollectionUtils.isEmpty(workTaskObjects)){
      String taskObjectsStr = workTaskObjects.stream().map(WorkTaskObject::getCustomerName).collect(Collectors.joining(";"));
      workTaskVo.setTaskObjectsStr(taskObjectsStr);
    }
  }

  /**
   * 转换数据(执行结果)
   *
   * @param workTaskVo 需要转换的数据
   * @return
   */
  private void transitionDetailData(WorkTaskVo workTaskVo){
    List<WorkTaskReceve> workTaskReceves = this.workTaskReceveService.findByTaskIds(Collections.singleton(workTaskVo.getId()));
    if(!CollectionUtils.isEmpty(workTaskReceves)){
      List<WorkTaskReceveVo> workTaskReceveVos = (List<WorkTaskReceveVo>) this.nebulaToolkitService.copyCollectionByBlankList(workTaskReceves
          , WorkTaskReceve.class, WorkTaskReceveVo.class, HashSet.class, ArrayList.class);
      //多人执行人
      StringJoiner executor = new StringJoiner("、");
      //已执行
      List<WorkTaskReceveVo> receveRespVos = new ArrayList<>();
      //未执行
      List<WorkTaskReceveVo> receveRespNoVos = new ArrayList<>();
      List<String> ids = Lists.newArrayList();
      for (WorkTaskReceveVo workTaskReceveVo : workTaskReceveVos) {
        if(SfaTaskStatusEnum.EXECUTE_LODING.getDictCode().equals(workTaskReceveVo.getExecuteStatus()) ||
            SfaTaskStatusEnum.ALREADY_FINISH.getDictCode().equals(workTaskReceveVo.getExecuteStatus())){
          receveRespVos.add(workTaskReceveVo);
          ids.add(workTaskReceveVo.getId());
        }
        if(SfaTaskStatusEnum.WAIT_EXECUTE.getDictCode().equals(workTaskReceveVo.getExecuteStatus()) ||
            SfaTaskStatusEnum.PAST_DUE.getDictCode().equals(workTaskReceveVo.getExecuteStatus())){
          receveRespNoVos.add(workTaskReceveVo);
        }
        executor.add(workTaskReceveVo.getReceverName());
      }
      if(!CollectionUtils.isEmpty(ids)){
        //各个执行人执行时的照片
        WorkTaskPictureDto workTaskPictureDto = new WorkTaskPictureDto();
        workTaskPictureDto.setTaskType(AttachmentBizTypeEnum.TASK_EXECUTE.getDictCode());
        workTaskPictureDto.setTaskIds(ids);
        List<WorkTaskPicture> workTaskPictures = this.workTaskPictureService.findList(workTaskPictureDto);
        if(!CollectionUtils.isEmpty(workTaskPictures)){
          List<WorkTaskPictureVo> workTaskPictureVos = (List<WorkTaskPictureVo>) this.nebulaToolkitService.copyCollectionByBlankList(workTaskPictures
              , WorkTaskPicture.class, WorkTaskPictureVo.class, HashSet.class, ArrayList.class);
          Map<String, List<WorkTaskPictureVo>> listMap = workTaskPictureVos.stream().collect(Collectors.groupingBy(WorkTaskPictureVo::getTaskId));
          for (WorkTaskReceveVo receveRespVo : receveRespVos) {
            receveRespVo.setExecuteTaskPicList(listMap.get(receveRespVo.getId()));
          }
        }
      }
      //汇总到任务
      workTaskVo.setExecutor(executor.toString());
      workTaskVo.setReceveRespVos(receveRespVos);
      workTaskVo.setReceveRespNoVos(receveRespNoVos);
      workTaskVo.setSumAll(String.valueOf(workTaskReceves.size()));
    }
  }

}
