/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.work.task.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskObject;
import com.biz.crm.sfa.business.work.task.local.repository.WorkTaskObjectRepository;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskObjectService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskObjectDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="workTaskObjectService")
public class WorkTaskObjectServiceImpl
implements WorkTaskObjectService {
    @Autowired
    private WorkTaskObjectRepository workTaskObjectRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<WorkTaskObject> findByConditions(Pageable pageable, WorkTaskObject workTaskObject) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)workTaskObject)) {
            workTaskObject = new WorkTaskObject();
        }
        return this.workTaskObjectRepository.findByConditions(pageable, workTaskObject);
    }

    @Override
    public List<WorkTaskObject> findList(WorkTaskObject workTaskObject) {
        return this.workTaskObjectRepository.findList(workTaskObject);
    }

    @Override
    @Transactional
    public void createBatch(List<WorkTaskObjectDto> workTaskObjectDtos) {
        this.createValidate(workTaskObjectDtos);
        List workTaskObjects = (List)this.nebulaToolkitService.copyCollectionByWhiteList(workTaskObjectDtos, WorkTaskObjectDto.class, WorkTaskObject.class, HashSet.class, ArrayList.class, new String[0]);
        this.workTaskObjectRepository.saveBatch(workTaskObjects);
    }

    private void createValidate(List<WorkTaskObjectDto> workTaskObjectDtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(workTaskObjectDtos) ? 1 : 0) != 0, (String)"\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        workTaskObjectDtos.forEach(workTaskObjectDto -> {
            Validate.notNull((Object)workTaskObjectDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            workTaskObjectDto.setId(null);
            Validate.notBlank((CharSequence)workTaskObjectDto.getTaskId(), (String)"\u65b0\u589e\u6570\u636e\u65f6,\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)workTaskObjectDto.getCustomerCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6,\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)workTaskObjectDto.getCustomerName(), (String)"\u65b0\u589e\u6570\u636e\u65f6,\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)workTaskObjectDto.getCustomerType(), (String)"\u65b0\u589e\u6570\u636e\u65f6,\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            workTaskObjectDto.setTenantCode(TenantUtils.getTenantCode());
            workTaskObjectDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            workTaskObjectDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
    }
}

