/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.work.task.local.service.internal;

import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskPicture;
import com.biz.crm.sfa.business.work.task.local.repository.WorkTaskPictureRepository;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskPictureService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskPictureDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="workTaskPictureService")
public class WorkTaskPictureServiceImpl
implements WorkTaskPictureService {
    @Autowired
    private WorkTaskPictureRepository workTaskPictureRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void createBatch(List<WorkTaskPictureDto> workTaskPictureDtos) {
        this.createValidate(workTaskPictureDtos);
        List workTaskPictures = (List)this.nebulaToolkitService.copyCollectionByWhiteList(workTaskPictureDtos, WorkTaskPictureDto.class, WorkTaskPicture.class, HashSet.class, ArrayList.class, new String[0]);
        this.workTaskPictureRepository.saveBatch(workTaskPictures);
    }

    @Override
    public List<WorkTaskPicture> findList(WorkTaskPictureDto workTaskPictureDto) {
        return this.workTaskPictureRepository.findList(workTaskPictureDto);
    }

    private void createValidate(List<WorkTaskPictureDto> workTaskPictureDtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(workTaskPictureDtos) ? 1 : 0) != 0, (String)"\u65b0\u589e\u5de5\u4f5c\u8ba1\u5212\u76f8\u5173\u7167\u7247\u65f6\uff0c\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        workTaskPictureDtos.forEach(workTaskPictureDto -> {
            Validate.notNull((Object)workTaskPictureDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            workTaskPictureDto.setId(null);
            Validate.notBlank((CharSequence)workTaskPictureDto.getFileName(), (String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)workTaskPictureDto.getObjectName(), (String)"\u6587\u4ef6\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)workTaskPictureDto.getUrl(), (String)"\u6587\u4ef6\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)workTaskPictureDto.getTaskId(), (String)"\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            workTaskPictureDto.setTenantCode(TenantUtils.getTenantCode());
        });
    }
}

