/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.work.task.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskReceve;
import com.biz.crm.sfa.business.work.task.local.repository.WorkTaskReceveRepository;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskPictureService;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskReceveService;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveDto;
import com.biz.crm.sfa.business.work.task.sdk.enums.AttachmentBizTypeEnum;
import com.biz.crm.sfa.business.work.task.sdk.enums.SfaTaskReleaseEnum;
import com.biz.crm.sfa.business.work.task.sdk.enums.SfaTaskStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class WorkTaskReceveServiceImpl
implements WorkTaskReceveService {
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private WorkTaskReceveRepository workTaskReceveRepository;
    @Autowired
    private WorkTaskPictureService workTaskPictureService;
    @Autowired
    private WorkTaskService workTaskService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void createBatch(List<WorkTaskReceveDto> workTaskReceveDtos) {
        this.createValidate(workTaskReceveDtos);
        List workTaskReceves = (List)this.nebulaToolkitService.copyCollectionByWhiteList(workTaskReceveDtos, WorkTaskReceveDto.class, WorkTaskReceve.class, HashSet.class, ArrayList.class, new String[0]);
        this.workTaskReceveRepository.saveBatch(workTaskReceves);
    }

    @Override
    @Transactional
    public WorkTaskReceve update(WorkTaskReceveDto workTaskReceveDto) {
        List pictures;
        this.updateValidate(workTaskReceveDto);
        WorkTaskReceve workTaskReceve = (WorkTaskReceve)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)workTaskReceveDto, WorkTaskReceve.class, HashSet.class, ArrayList.class, new String[0]));
        workTaskReceve.setReleaseDate(new Date());
        this.workTaskReceveRepository.updateById((Object)workTaskReceve);
        WorkTaskReceveDto workTaskReceveQueryDto = new WorkTaskReceveDto();
        workTaskReceveQueryDto.setTaskId(workTaskReceve.getTaskId());
        List<WorkTaskReceve> workTaskReceves = this.workTaskReceveRepository.findByConditions(workTaskReceveQueryDto);
        if (!CollectionUtils.isEmpty(workTaskReceves)) {
            String[] status = this.getStatus(workTaskReceves, workTaskReceve.getId(), workTaskReceve.getExecuteStatus());
            WorkTaskDto workTaskDto = new WorkTaskDto();
            workTaskDto.setId(workTaskReceveDto.getTaskId());
            workTaskDto.setProgress(status[0]);
            workTaskDto.setTaskStatus(status[1]);
            this.workTaskService.updateProgressAndTaskStatusById(workTaskDto);
        }
        if (!CollectionUtils.isEmpty((Collection)(pictures = workTaskReceveDto.getExecuteTaskPicList()))) {
            pictures.forEach(workTaskPictureDto -> {
                workTaskPictureDto.setTaskId(workTaskReceve.getId());
                workTaskPictureDto.setTaskType(AttachmentBizTypeEnum.TASK_EXECUTE.getDictCode());
            });
            this.workTaskPictureService.createBatch(pictures);
        }
        return workTaskReceve;
    }

    @Override
    @Transactional
    @DynamicTaskService(cornExpression="0 0 0 * * ?", taskDesc="\u4efb\u52a1\u5b9a\u65f6\u8fc7\u671f\u7b56\u7565")
    public void timeExpiredTask() {
        WorkTaskReceveDto workTaskReceveQueryDto = new WorkTaskReceveDto();
        workTaskReceveQueryDto.setExecuteStatus(SfaTaskStatusEnum.WAIT_EXECUTE.getDictCode());
        workTaskReceveQueryDto.setEndDate(new Date());
        List<WorkTaskReceve> workTaskReceves = this.findByConditions(workTaskReceveQueryDto);
        if (!CollectionUtils.isEmpty(workTaskReceves)) {
            List workTaskReceveDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(workTaskReceves, WorkTaskReceve.class, WorkTaskReceveDto.class, HashSet.class, ArrayList.class, new String[0]);
            workTaskReceveDtos.forEach(workTaskReceveDto -> {
                workTaskReceveDto.setExecuteStatus(SfaTaskStatusEnum.PAST_DUE.getDictCode());
                this.update((WorkTaskReceveDto)workTaskReceveDto);
            });
        }
    }

    @Override
    public List<WorkTaskReceve> findByConditions(WorkTaskReceveDto workTaskReceveDto) {
        return this.workTaskReceveRepository.findByConditions(workTaskReceveDto);
    }

    @Override
    public List<WorkTaskReceve> findByTaskIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        return this.workTaskReceveRepository.findByTaskIds(ids);
    }

    private void createValidate(List<WorkTaskReceveDto> workTaskReceveDtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(workTaskReceveDtos) ? 1 : 0) != 0, (String)"\u65b0\u589e\u65f6\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (WorkTaskReceveDto sfaStaffMessageReqVo : workTaskReceveDtos) {
            Validate.notBlank((CharSequence)sfaStaffMessageReqVo.getReceverCode(), (String)"\u4efb\u52a1\u6267\u884c\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)sfaStaffMessageReqVo.getReceverOrgCode(), (String)"\u4efb\u52a1\u6267\u884c\u4eba\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)sfaStaffMessageReqVo.getReceverOrgName(), (String)"\u4efb\u52a1\u6267\u884c\u4eba\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)sfaStaffMessageReqVo.getTaskId(), (String)"\u4efb\u52a1\u6267\u884c\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)sfaStaffMessageReqVo.getReceverPosCode(), (String)"\u4efb\u52a1\u6267\u884c\u4eba\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)sfaStaffMessageReqVo.getReceverPosName(), (String)"\u4efb\u52a1\u6267\u884c\u4eba\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            sfaStaffMessageReqVo.setTenantCode(TenantUtils.getTenantCode());
            sfaStaffMessageReqVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            sfaStaffMessageReqVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            sfaStaffMessageReqVo.setExecuteStatus(SfaTaskStatusEnum.WAIT_EXECUTE.getDictCode());
            sfaStaffMessageReqVo.setReceveDate(new Date());
        }
    }

    private void updateValidate(WorkTaskReceveDto workTaskReceveDto) {
        Validate.notBlank((CharSequence)workTaskReceveDto.getId(), (String)"\u7f16\u8f91\u65f6\uff0c\u4efb\u52a1\u63a5\u6536\u4f20\u5165Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)workTaskReceveDto.getTaskId(), (String)"\u7f16\u8f91\u65f6\uff0c\u4efb\u52a1\u63a5\u6536\u53d1\u5e03Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (SfaTaskStatusEnum.EXECUTE_LODING.getDictCode().equals(workTaskReceveDto.getExecuteStatus())) {
            Validate.notBlank((CharSequence)workTaskReceveDto.getSummary(), (String)"\u7f16\u8f91\u65f6\uff0c\u8bf7\u8f93\u5165\u6267\u884c\u603b\u7ed3", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)workTaskReceveDto.getExecuteStatus(), (String)"\u7f16\u8f91\u65f6\uff0c\u8bf7\u8f93\u5165\u6267\u884c\u72b6\u6001\u7ed3\u679c", (Object[])new Object[0]);
    }

    private String[] getStatus(List<WorkTaskReceve> receveRespVos, String id, String exStatus) {
        boolean b;
        int toPerformNum = 0;
        int offTheStocksNum = 0;
        int submittedNum = 0;
        int haveExpiredNum = 0;
        String[] list = new String[]{"", ""};
        int size = receveRespVos.size();
        for (WorkTaskReceve next : receveRespVos) {
            if (id.equals(next.getId())) {
                next.setExecuteStatus(exStatus);
            }
            switch (next.getExecuteStatus()) {
                case "0": {
                    ++toPerformNum;
                    break;
                }
                case "1": {
                    ++offTheStocksNum;
                    break;
                }
                case "2": {
                    ++submittedNum;
                    break;
                }
                case "3": {
                    ++haveExpiredNum;
                    break;
                }
            }
        }
        boolean bl = b = offTheStocksNum == size || offTheStocksNum + submittedNum == size;
        if (offTheStocksNum > 0 && b) {
            list[0] = size + "/" + size;
            list[1] = SfaTaskReleaseEnum.EXECUTE_LODING.getDictCode();
            return list;
        }
        if (offTheStocksNum > 0 || submittedNum > 0) {
            list[0] = offTheStocksNum + submittedNum + "/" + size;
            list[1] = SfaTaskReleaseEnum.PARTLY_COMPLETED.getDictCode();
            return list;
        }
        if (offTheStocksNum == 0 && toPerformNum > 0 && submittedNum == 0) {
            list[0] = submittedNum + "/" + size;
            list[1] = SfaTaskReleaseEnum.WAIT_EXECUTE.getDictCode();
            return list;
        }
        if (submittedNum == size) {
            list[0] = size + "/" + size;
            list[1] = SfaTaskReleaseEnum.ALREADY_FINISH.getDictCode();
            return list;
        }
        if (haveExpiredNum == size) {
            list[0] = "0/" + size;
            list[1] = SfaTaskReleaseEnum.PAST_DUE.getDictCode();
            return list;
        }
        if (offTheStocksNum == 0 && toPerformNum == 0) {
            list[0] = offTheStocksNum + "/" + size;
            list[1] = SfaTaskReleaseEnum.UNFINISHED.getDictCode();
            return list;
        }
        return list;
    }
}

