/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.work.task.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.FileEntity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskPicture;
import com.biz.crm.sfa.business.work.task.local.repository.WorkTaskReceveRepository;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskPictureService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskPictureDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReportDto;
import com.biz.crm.sfa.business.work.task.sdk.enums.AttachmentBizTypeEnum;
import com.biz.crm.sfa.business.work.task.sdk.service.WorkTaskReportVoService;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WorkTaskReportVoServiceImpl
implements WorkTaskReportVoService {
    private static final Logger log = LoggerFactory.getLogger(WorkTaskReportVoServiceImpl.class);
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private WorkTaskReceveRepository workTaskReceveRepository;
    @Autowired
    private WorkTaskPictureService workTaskPictureService;

    public Page<WorkTaskReportVo> findByConditions(Pageable pageable, WorkTaskReportDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (WorkTaskReportDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new WorkTaskReportDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<WorkTaskReportVo> entityPage = this.workTaskReceveRepository.findSfaWorkTaskReportList(pageable, dto);
        List records = entityPage.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            records.forEach(data -> {
                WorkTaskPictureDto workTaskPictureDto = new WorkTaskPictureDto();
                workTaskPictureDto.setTaskIds(Collections.singletonList(data.getId()));
                workTaskPictureDto.setTaskType(AttachmentBizTypeEnum.TASK_EXECUTE.getDictCode());
                List<WorkTaskPicture> executePicUrlList = this.workTaskPictureService.findList(workTaskPictureDto);
                if (!CollectionUtils.isEmpty(executePicUrlList)) {
                    data.setExecuteTaskPicList(executePicUrlList.stream().map(FileEntity::getUrl).collect(Collectors.toList()));
                }
                workTaskPictureDto.setTaskIds(Collections.singletonList(data.getTaskId()));
                workTaskPictureDto.setTaskType(AttachmentBizTypeEnum.TASK_ADD.getDictCode());
                List<WorkTaskPicture> sendTaskPicList = this.workTaskPictureService.findList(workTaskPictureDto);
                if (!CollectionUtils.isEmpty(sendTaskPicList)) {
                    data.setSendTaskPicList(sendTaskPicList.stream().map(FileEntity::getUrl).collect(Collectors.toList()));
                }
            });
        }
        return entityPage;
    }

    public WorkTaskReportVo findById(String id) {
        WorkTaskReportDto workTaskReportDto = new WorkTaskReportDto();
        workTaskReportDto.setId(id);
        List records = this.findByConditions(null, workTaskReportDto).getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            return (WorkTaskReportVo)records.get(0);
        }
        return null;
    }
}

