/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.work.task.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTask;
import com.biz.crm.sfa.business.work.task.local.repository.WorkTaskRepository;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskObjectService;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskPictureService;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskReceveService;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskDto;
import com.biz.crm.sfa.business.work.task.sdk.enums.AttachmentBizTypeEnum;
import com.biz.crm.sfa.business.work.task.sdk.enums.SfaTaskReleaseEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="workTaskService")
public class WorkTaskServiceImpl
implements WorkTaskService {
    @Autowired
    private WorkTaskRepository workTaskRepository;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private WorkTaskReceveService workTaskReceveService;
    @Autowired
    private WorkTaskObjectService workTaskObjectService;
    @Autowired
    private WorkTaskPictureService workTaskPictureService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    @Transactional
    public WorkTask create(WorkTaskDto workTaskDto) {
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        this.createValidate(workTaskDto);
        List reqVos = workTaskDto.getSfaStaffMessageReqVos();
        WorkTask entity = (WorkTask)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)workTaskDto, WorkTask.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setCreatePosCode(loginDetails.getPostCode());
        entity.setCreatePosName(loginDetails.getPostName());
        entity.setCreateOrgCode(loginDetails.getOrgCode());
        entity.setCreateOrgName(loginDetails.getOrgName());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setTaskStatus(SfaTaskReleaseEnum.WAIT_EXECUTE.getDictCode());
        entity.setProgress("0/" + (CollectionUtils.isEmpty((Collection)reqVos) ? "0" : Integer.valueOf(reqVos.size())));
        entity.setTaskCode((String)this.generateCodeService.generateCode("xxx", 1).get(0));
        this.workTaskRepository.save((Object)entity);
        reqVos.forEach(workTaskReceveDto -> workTaskReceveDto.setTaskId(entity.getId()));
        this.workTaskReceveService.createBatch(reqVos);
        List pictures = workTaskDto.getPictures();
        if (!CollectionUtils.isEmpty((Collection)pictures)) {
            pictures.forEach(workTaskPictureDto -> {
                workTaskPictureDto.setTaskId(entity.getId());
                workTaskPictureDto.setTaskType(AttachmentBizTypeEnum.TASK_ADD.getDictCode());
            });
            this.workTaskPictureService.createBatch(pictures);
        }
        List taskObjects = workTaskDto.getTaskObjects();
        if (!CollectionUtils.isEmpty((Collection)pictures)) {
            taskObjects.forEach(workTaskObjectDto -> workTaskObjectDto.setTaskId(entity.getId()));
            this.workTaskObjectService.createBatch(taskObjects);
        }
        return entity;
    }

    @Override
    @Transactional
    public void updateProgressAndTaskStatusById(WorkTaskDto workTaskDto) {
        Validate.notNull((Object)workTaskDto, (String)"\u7f16\u8f91\u8fdb\u5ea6\u548c\u72b6\u6001\u65f6\uff0c\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)workTaskDto.getId(), (String)"\u7f16\u8f91\u8fdb\u5ea6\u548c\u72b6\u6001\u65f6\uff0c\u4f20\u5165\u4e3b\u952e\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)workTaskDto.getProgress(), (String)"\u7f16\u8f91\u8fdb\u5ea6\u548c\u72b6\u6001\u65f6\uff0c\u4f20\u5165\u8fdb\u5ea6\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)workTaskDto.getTaskStatus(), (String)"\u7f16\u8f91\u8fdb\u5ea6\u548c\u72b6\u6001\u65f6\uff0c\u4f20\u5165\u72b6\u6001\u4e3a\u7a7a", (Object[])new Object[0]);
        this.workTaskRepository.updateProgressAndTaskStatusById(workTaskDto);
    }

    private void createValidate(WorkTaskDto workTaskDto) {
        Validate.notNull((Object)workTaskDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        workTaskDto.setTenantCode(TenantUtils.getTenantCode());
        workTaskDto.setId(null);
        Validate.notBlank((CharSequence)workTaskDto.getContent(), (String)"\u65b0\u589e\u6570\u636e\u65f6,\u4efb\u52a1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)workTaskDto.getTaskTitle(), (String)"\u65b0\u589e\u6570\u636e\u65f6,\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)workTaskDto.getEndDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6,\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Date startDate = new Date();
        Validate.isTrue((boolean)workTaskDto.getEndDate().after(startDate), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)workTaskDto.getSfaStaffMessageReqVos()) ? 1 : 0) != 0, (String)"\u8bf7\u6307\u5b9a\u4efb\u52a1\u6267\u884c\u4eba", (Object[])new Object[0]);
    }
}

