/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.work.task.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTask;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskObject;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskPicture;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskReceve;
import com.biz.crm.sfa.business.work.task.local.repository.WorkTaskRepository;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskObjectService;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskPictureService;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskReceveService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskPictureDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskQueryDto;
import com.biz.crm.sfa.business.work.task.sdk.enums.AttachmentBizTypeEnum;
import com.biz.crm.sfa.business.work.task.sdk.enums.SfaTaskStatusEnum;
import com.biz.crm.sfa.business.work.task.sdk.service.WorkTaskVoService;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskPictureVo;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReceveVo;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WorkTaskVoServiceImpl
implements WorkTaskVoService {
    private static final Logger log = LoggerFactory.getLogger(WorkTaskVoServiceImpl.class);
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private WorkTaskRepository workTaskRepository;
    @Autowired
    private WorkTaskPictureService workTaskPictureService;
    @Autowired
    private WorkTaskObjectService workTaskObjectService;
    @Autowired
    private WorkTaskReceveService workTaskReceveService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<WorkTaskVo> findByConditions(Pageable pageable, WorkTaskQueryDto workTaskQueryDto) {
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(workTaskQueryDto)) {
            workTaskQueryDto = new WorkTaskQueryDto();
        }
        workTaskQueryDto.setCreateOrgCode(loginDetails.getOrgCode());
        workTaskQueryDto.setCreatePosCode(loginDetails.getPostCode());
        workTaskQueryDto.setCreateAccount(loginDetails.getAccount());
        Page<WorkTaskVo> workTaskVoPage = this.workTaskRepository.findVoByConditions(pageable, workTaskQueryDto);
        this.transitionPageData(workTaskVoPage.getRecords());
        return workTaskVoPage;
    }

    public WorkTaskVo findDetailById(String id) {
        WorkTask workTask = (WorkTask)((Object)this.workTaskRepository.getById((Serializable)((Object)id)));
        if (Objects.nonNull((Object)workTask)) {
            WorkTaskVo workTaskVo = (WorkTaskVo)this.nebulaToolkitService.copyObjectByBlankList((Object)workTask, WorkTaskVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.transitionData(workTaskVo);
            this.transitionDetailData(workTaskVo);
            return workTaskVo;
        }
        return null;
    }

    private String getPercentage(Integer molecule, Integer denominator) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat.format((float)molecule.intValue() / (float)denominator.intValue() * 100.0f);
    }

    private void transitionPageData(List<WorkTaskVo> workTaskVos) {
        if (!CollectionUtils.isEmpty(workTaskVos)) {
            List<WorkTaskReceve> workTaskReceves;
            HashSet<String> setTaskId = new HashSet<String>();
            workTaskVos.forEach(workTaskVo -> {
                String progress = workTaskVo.getProgress();
                String[] split = progress.split("/");
                workTaskVo.setQuantityNum(split[0]);
                workTaskVo.setSumAll(split[1]);
                if ("1".equals(split[1])) {
                    setTaskId.add(workTaskVo.getId());
                }
                workTaskVo.setProgress(this.getPercentage(Integer.valueOf(split[0]), Integer.valueOf(split[1])));
            });
            if (!CollectionUtils.isEmpty(setTaskId) && !CollectionUtils.isEmpty(workTaskReceves = this.workTaskReceveService.findByTaskIds(setTaskId))) {
                Map<String, WorkTaskReceve> workTaskReceveMap = workTaskReceves.stream().collect(Collectors.toMap(WorkTaskReceve::getTaskId, a -> a));
                workTaskVos.forEach(workTaskVo -> {
                    WorkTaskReceve workTaskReceve = (WorkTaskReceve)((Object)((Object)workTaskReceveMap.get(workTaskVo.getId())));
                    if (Objects.nonNull((Object)workTaskReceve)) {
                        workTaskVo.setExecutor(workTaskReceve.getReceverName());
                    }
                });
            }
        }
    }

    private void transitionData(WorkTaskVo workTaskVo) {
        WorkTaskPictureDto workTaskPictureDto = new WorkTaskPictureDto();
        workTaskPictureDto.setTaskIds(Collections.singletonList(workTaskVo.getId()));
        workTaskPictureDto.setTaskType(AttachmentBizTypeEnum.TASK_ADD.getDictCode());
        List<WorkTaskPicture> workTaskPictures = this.workTaskPictureService.findList(workTaskPictureDto);
        if (!CollectionUtils.isEmpty(workTaskPictures)) {
            List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(workTaskPictures, WorkTaskPicture.class, WorkTaskPictureVo.class, HashSet.class, ArrayList.class, new String[0]);
            workTaskVo.setSendTaskPicList(list);
        }
        WorkTaskObject workTaskObject = new WorkTaskObject();
        workTaskObject.setTaskId(workTaskVo.getId());
        List<WorkTaskObject> workTaskObjects = this.workTaskObjectService.findList(workTaskObject);
        if (!CollectionUtils.isEmpty(workTaskObjects)) {
            String taskObjectsStr = workTaskObjects.stream().map(WorkTaskObject::getCustomerName).collect(Collectors.joining(";"));
            workTaskVo.setTaskObjectsStr(taskObjectsStr);
        }
    }

    private void transitionDetailData(WorkTaskVo workTaskVo) {
        List<WorkTaskReceve> workTaskReceves = this.workTaskReceveService.findByTaskIds(Collections.singleton(workTaskVo.getId()));
        if (!CollectionUtils.isEmpty(workTaskReceves)) {
            List workTaskReceveVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(workTaskReceves, WorkTaskReceve.class, WorkTaskReceveVo.class, HashSet.class, ArrayList.class, new String[0]);
            StringJoiner executor = new StringJoiner("\u3001");
            ArrayList<WorkTaskReceveVo> receveRespVos = new ArrayList<WorkTaskReceveVo>();
            ArrayList<WorkTaskReceveVo> receveRespNoVos = new ArrayList<WorkTaskReceveVo>();
            ArrayList ids = Lists.newArrayList();
            for (WorkTaskReceveVo workTaskReceveVo : workTaskReceveVos) {
                if (SfaTaskStatusEnum.EXECUTE_LODING.getDictCode().equals(workTaskReceveVo.getExecuteStatus()) || SfaTaskStatusEnum.ALREADY_FINISH.getDictCode().equals(workTaskReceveVo.getExecuteStatus())) {
                    receveRespVos.add(workTaskReceveVo);
                    ids.add(workTaskReceveVo.getId());
                }
                if (SfaTaskStatusEnum.WAIT_EXECUTE.getDictCode().equals(workTaskReceveVo.getExecuteStatus()) || SfaTaskStatusEnum.PAST_DUE.getDictCode().equals(workTaskReceveVo.getExecuteStatus())) {
                    receveRespNoVos.add(workTaskReceveVo);
                }
                executor.add(workTaskReceveVo.getReceverName());
            }
            if (!CollectionUtils.isEmpty((Collection)ids)) {
                WorkTaskPictureDto workTaskPictureDto = new WorkTaskPictureDto();
                workTaskPictureDto.setTaskType(AttachmentBizTypeEnum.TASK_EXECUTE.getDictCode());
                workTaskPictureDto.setTaskIds((List)ids);
                List<WorkTaskPicture> workTaskPictures = this.workTaskPictureService.findList(workTaskPictureDto);
                if (!CollectionUtils.isEmpty(workTaskPictures)) {
                    List workTaskPictureVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(workTaskPictures, WorkTaskPicture.class, WorkTaskPictureVo.class, HashSet.class, ArrayList.class, new String[0]);
                    Map<String, List<WorkTaskPictureVo>> listMap = workTaskPictureVos.stream().collect(Collectors.groupingBy(WorkTaskPictureVo::getTaskId));
                    for (WorkTaskReceveVo receveRespVo : receveRespVos) {
                        receveRespVo.setExecuteTaskPicList(listMap.get(receveRespVo.getId()));
                    }
                }
            }
            workTaskVo.setExecutor(executor.toString());
            workTaskVo.setReceveRespVos(receveRespVos);
            workTaskVo.setReceveRespNoVos(receveRespNoVos);
            workTaskVo.setSumAll(String.valueOf(workTaskReceves.size()));
        }
    }
}

