package com.biz.crm.sfa.business.work.task.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTask;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * 工作计划发布表(WorkTask)
 *
 * @author rentao
 * @since 2022-06-13 14:04:52
 */
@RestController
@RequestMapping("/v1/workTask/workTask")
@Slf4j
@Api(tags = "工作计划发布表:WorkTask:工作计划发布表")
public class WorkTaskController {

  @Autowired
  private WorkTaskService workTaskService;

  /**
   * 新增
   *
   * @param workTaskDto 新增参数
   *
  */
  @ApiOperation(value = "新增")
  @PostMapping
  public Result<WorkTask> create(@ApiParam(name = "workTaskDto", value = "工作计划发布表") @RequestBody WorkTaskDto workTaskDto) {
    try {
      WorkTask result = this.workTaskService.create(workTaskDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
