package com.biz.crm.sfa.business.work.task.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskReceveService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveQueryDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReportDto;
import com.biz.crm.sfa.business.work.task.sdk.service.WorkTaskReceveVoService;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReceveVo;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 工作计划接收执行vo controller
 * @author: rentao
 * @date: 2022/6/15 13:59
 */
@RestController
@RequestMapping("/v1/workTask/workTaskReceve")
@Slf4j
@Api(tags = "工作计划接收执行:workTaskReceveVo:工作计划接收执行")
public class WorkTaskReceveVoController {

  @Autowired private WorkTaskReceveVoService workTaskReceveVoService;

  /**
   * 分页查询（登录人）工作任务接收
   *
   * @param pageable 分页信息
   * @param dto 参数Dto
   * @return 查询工作任务报表
   */
  @ApiOperation(value = "分页查询（登录人）工作任务接收")
  @GetMapping("/findByConditions")
  public Result<Page<WorkTaskReceveVo>> findByConditions(
      @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "WorkTaskReceveQueryDto", value = "分页Dto") WorkTaskReceveQueryDto dto) {
    try {
      return Result.ok(this.workTaskReceveVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * id查询
   *
   * @param id 主键
   */
  @ApiOperation(value = "id查询")
  @GetMapping("{id}")
  public Result<WorkTaskReceveVo> findDetailById(
      @PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      WorkTaskReceveVo workTaskReceveVo = this.workTaskReceveVoService.findDetailById(id);
      return Result.ok(workTaskReceveVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 分页查询（登录人）工作任务接收
   *
   * @param pageable 分页信息
   * @param dto 参数Dto
   * @return 查询工作任务报表
   */
  @ApiOperation(value = "分页查询（登录人）工作任务当日完成接收和待执行任务")
  @GetMapping("/findDayPlan")
  public Result<Page<WorkTaskReceveVo>> findDayPlan(
      @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "WorkTaskReceveQueryDto", value = "分页Dto") WorkTaskReceveQueryDto dto) {
    try {
      return Result.ok(this.workTaskReceveVoService.findDayPlan(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 分页查询（登录人）工作任务接收
   *
   * @param queryDate 查询日期
   * @return 查询工作任务报表
   */
  @ApiOperation(value = "查询（登录人）工作任务当日完成接收和待执行任务")
  @GetMapping("/findDayPlanProgress")
  public Result<String> findDayPlanProgress(@RequestParam("queryDate") String queryDate) {
    try {
      String dayPlanProgress = this.workTaskReceveVoService.findDayPlanProgress(queryDate);
      Result result = new Result();
      result.setResult(dayPlanProgress);
      return result;
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
