package com.biz.crm.sfa.business.work.task.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 工作任务(发布)实体
 * @author: rentao
 * @date: 2022/6/13 14:11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_work_task")
@Table(name = "sfa_work_task", indexes = {
    @Index(name = "sfa_work_task_index1", columnList = "tenant_code,task_code", unique = true),
})
@ApiModel(value = "WorkTask", description = "工作任务(发布)")
@org.hibernate.annotations.Table(appliesTo = "sfa_work_task", comment = "工作任务(发布)")
public class WorkTask extends TenantFlagOpEntity {

  private static final long serialVersionUID = -6617450568742492519L;

  /**
   * 任务标题
   */
  @ApiModelProperty("任务标题")
  @Column(name = "task_title", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '任务标题'")
  private String taskTitle;


  /**
   * 任务编码
   */
  @ApiModelProperty("任务编码")
  @Column(name = "task_code", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '任务编码'")
  private String taskCode;

  /**
   * 任务内容
   */
  @ApiModelProperty("任务内容")
  @Column(name = "content", length = 512, nullable = false, columnDefinition = "varchar(512) COMMENT '任务内容'")
  private String content;

  /**
   * 任务进度
   */
  @ApiModelProperty("任务进度")
  @Column(name = "progress", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '任务进度'")
  private String progress;

  /**
   * 任务状态
   */
  @ApiModelProperty("任务状态")
  @Column(name = "task_status", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '任务状态'")
  private String taskStatus;

  /**
   * 开始时间
   */
  @ApiModelProperty("开始时间")
  @Column(name = "start_date", length = 20, columnDefinition = "datetime COMMENT '开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startDate;

  /**
   * 截至时间
   */
  @ApiModelProperty("截至时间")
  @Column(name = "end_date", length = 20, columnDefinition = "datetime COMMENT '截至时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endDate;

  /**
   * 地址
   */
  @ApiModelProperty("地址")
  @Column(name = "task_site", length = 200, columnDefinition = "varchar(200) COMMENT '地址'")
  private String taskSite;

  /**
   * 创建人岗位
   */
  @ApiModelProperty("创建人岗位名称")
  @Column(name = "create_pos_name", length = 200, columnDefinition = "varchar(200) COMMENT '创建人岗位名称'")
  private String createPosName;

  /**
   * 创建人岗位
   */
  @ApiModelProperty("创建人岗位")
  @Column(name = "create_pos_code", length = 200, columnDefinition = "varchar(200) COMMENT '创建人岗位'")
  private String createPosCode;

  /**
   * 创建人组织
   */
  @ApiModelProperty("创建人组织")
  @Column(name = "create_org_code", length = 200, columnDefinition = "varchar(200) COMMENT '创建人组织'")
  private String createOrgCode;

  /**
   * 创建人组织名称
   */
  @ApiModelProperty("创建人组织名称")
  @Column(name = "create_org_name", length = 200, columnDefinition = "varchar(200) COMMENT '创建人组织名称'")
  private String createOrgName;



}
