package com.biz.crm.sfa.business.work.task.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 工作任务图片
 * @author: rentao
 * @date: 2022/6/13 14:22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_work_task_picture")
@Table(name = "sfa_work_task_picture", indexes = {
    @Index(name = "sfa_work_task_picture_index1", columnList = "task_id"),
})
@ApiModel(value = "WorkTaskPicture", description = "工作任务-图片")
@org.hibernate.annotations.Table(appliesTo = "sfa_work_task_picture", comment = "工作任务(图片)")
public class WorkTaskPicture extends FileEntity {


  private static final long serialVersionUID = -2907621585607605964L;

  /**
   * 工作任务id
   */
  @ApiModelProperty("工作任务id")
  @Column(name = "task_id", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '工作任务id'")
  private String taskId;

  /**
   * 工作类型
   */
  @ApiModelProperty("工作类型")
  @Column(name = "task_type", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '工作类型'")
  private String taskType;

}
