package com.biz.crm.sfa.business.work.task.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 工作任务(接收) 实体
 * @author: rentao
 * @date: 2022/6/13 14:23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_work_task_receve")
@Table(name = "sfa_work_task_receve", indexes = {
    @Index(name = "sfa_work_task_receve_index1", columnList = "task_id"),
})
@ApiModel(value = "WorkTaskReceve", description = "工作任务(接收)")
@org.hibernate.annotations.Table(appliesTo = "sfa_work_task_receve", comment = "工作任务(接收)")
public class WorkTaskReceve extends TenantFlagOpEntity {

  private static final long serialVersionUID = 8718727265254919736L;

  /**
   * 任务id
   */
  @ApiModelProperty("任务id")
  @Column(name = "task_id", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '任务id'")
  private String taskId;

  /**
   * 接收人姓名
   */
  @ApiModelProperty("接收人姓名")
  @Column(name = "recever_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '接收人姓名'")
  private String receverName;

  /**
   * 接收人账号
   */
  @ApiModelProperty("接收人账号")
  @Column(name = "recever_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '接收人账号'")
  private String receverCode;

  /**
   * 接收人组织编码
   */
  @ApiModelProperty("接收人组织编码")
  @Column(name = "recever_org_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '接收人组织编码'")
  private String receverOrgCode;

  /**
   * 接收人组织名称
   */
  @ApiModelProperty("接收人组织名称")
  @Column(name = "recever_org_name", length = 32, columnDefinition = "varchar(32) COMMENT '接收人组织名称'")
  private String receverOrgName;

  /**
   * 接收人职位编码
   */
  @ApiModelProperty("接收人职位编码")
  @Column(name = "recever_pos_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '接收人职位编码'")
  private String receverPosCode;

  /**
   * 接收人职位名称
   */
  @ApiModelProperty("接收人职位编码")
  @Column(name = "recever_pos_name", length = 32, columnDefinition = "varchar(32) COMMENT '接收人职位名称'")
  private String receverPosName;

  /**
   * 接收时间
   */
  @ApiModelProperty("接收时间")
  @Column(name = "receve_date", length = 20, columnDefinition = "datetime COMMENT '接收时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date receveDate;

  /**
   * 执行时定位地址
   */
  @ApiModelProperty("执行时定位地址")
  @Column(name = "address",columnDefinition = "varchar(255) COMMENT '执行时定位地址'")
  private String address;

  /**
   * 执行总结
   */
  @ApiModelProperty("执行总结")
  @Column(name = "summary",columnDefinition = "varchar(255) COMMENT '执行总结'")
  private String summary;

  /**
   * 执行状态
   */
  @ApiModelProperty("执行状态")
  @Column(name = "execute_status", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '执行状态'")
  private String executeStatus;

  /**
   * 执行时间
   */
  @ApiModelProperty("执行时间")
  @Column(name = "release_date", length = 20, columnDefinition = "datetime COMMENT '执行时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date releaseDate;
}
