package com.biz.crm.sfa.business.work.task.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTask;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskQueryDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveQueryDto;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReceveVo;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskVo;
import org.apache.ibatis.annotations.Param;

/**
 * 工作计划发布表(WorkTask)mybatismapper
 *
 * @author rentao
 * @since 2022-06-13 14:04:59
 */
public interface WorkTaskMapper extends BaseMapper<WorkTask> {

  /**
   * 分页查询
   *
   * @param page 分页参数
   * @param workTask 分页条件
   */
   Page<WorkTask> findByConditions(
      @Param("page") Page<WorkTask> page, @Param("workTask") WorkTask workTask);

  /**
   * 分页查询
   *
   * @param page 分页参数
   * @param workTaskQueryDto 分页条件
   */
  Page<WorkTaskVo> findVoByConditions(
      @Param("page") Page<WorkTaskVo> page,
      @Param("dto") WorkTaskQueryDto workTaskQueryDto);
}
