package com.biz.crm.sfa.business.work.task.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskReceve;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveQueryDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReportDto;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReceveVo;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReportVo;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 工作计划发布表(WorkTaskReceve)mybatismaper
 *
 * @author rentao
 * @since 2022-06-13 14:05:00
 */
public interface WorkTaskReceveMapper extends BaseMapper<WorkTaskReceve> {

  /**
   * 分页查询
   *
   * @param page 分页参数
   * @param workTaskReceveDto 分页条件
   */
   Page<WorkTaskReceve> findByConditions(
      @Param("page") Page<WorkTaskReceve> page,
      @Param("dto") WorkTaskReceveDto workTaskReceveDto);


  /**
   * 分页查询
   *
   * @param page 分页参数
   * @param workTaskReceveQueryDto 分页条件
   */
   Page<WorkTaskReceveVo> findVoByConditions(
      @Param("page") Page<WorkTaskReceveVo> page,
      @Param("dto") WorkTaskReceveQueryDto workTaskReceveQueryDto);

  /**
   * 分页查询
   *
   * @param page 分页参数
   * @param WorkTaskReportDto 分页条件
   */
   Page<WorkTaskReportVo> findSfaWorkTaskReportList(
      @Param("page") Page<WorkTaskReportVo> page,
      @Param("dto") WorkTaskReportDto WorkTaskReportDto);

  /**
   * 条件查询不分页
   * @param workTaskReceveDto
   * @return
   */
  List<WorkTaskReceve> findByConditions(@Param("dto") WorkTaskReceveDto workTaskReceveDto);


  /**
   * id查询详情
   * @param id
   * @return
   */
  WorkTaskReceveVo findDetailById(@Param("id") String id);


  /**
   * 分页查询
   *
   * @param page 分页参数
   * @param workTaskReceveQueryDto 分页条件
   */
  Page<WorkTaskReceveVo> findDayPlan(@Param("page") Page<WorkTaskReceveVo> page, @Param("dto") WorkTaskReceveQueryDto workTaskReceveQueryDto);

  /**
   * 查询当日任务
   *
   * @param workTaskReceveQueryDto 分页条件
   */
  List<WorkTaskReceveVo> findDayPlan(@Param("dto") WorkTaskReceveQueryDto workTaskReceveQueryDto);
}
