package com.biz.crm.sfa.business.work.task.local.repository;

import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskObject;
import com.biz.crm.sfa.business.work.task.local.mapper.WorkTaskObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import java.util.List;

/**
 * 工作任务-执行对象(WorkTaskObject)Repository
 *
 * @author rentao
 * @since 2022-06-13 14:05:00
 */
@Component
public class WorkTaskObjectRepository extends ServiceImpl<WorkTaskObjectMapper, WorkTaskObject> {

  @Autowired private WorkTaskObjectMapper workTaskObjectMapper;

  /**
   * 分页查询
   *
   * @param pageable 分页参数
   * @param workTaskObject 分页条件
   */
  public Page<WorkTaskObject> findByConditions(Pageable pageable, WorkTaskObject workTaskObject) {
    Page<WorkTaskObject> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<WorkTaskObject> pageList =
        this.workTaskObjectMapper.findByConditions(page, workTaskObject);
    return pageList;
  }

  /**
   * 条件查询
   *
   * @param workTaskObject
   */
  public List<WorkTaskObject> findList(WorkTaskObject workTaskObject) {
    return this.workTaskObjectMapper.findByConditions(workTaskObject);
  }

  /**
   * 根据id集合更新启禁用装填
   *
   * @param ids 分页对象
   * @param enableStatus 启禁用状态对象
   * @return
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(WorkTaskObject::getId, ids)
        .set(WorkTaskObject::getEnableStatus, enableStatus.getCode())
        .update();
  }
}
