package com.biz.crm.sfa.business.work.task.local.repository;

import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskPicture;
import com.biz.crm.sfa.business.work.task.local.mapper.WorkTaskPictureMapper;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskPictureDto;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import java.util.List;

/**
 * 工作计划相关照片(WorkTaskPicture)Repository
 *
 * @author rentao
 * @since 2022-06-13 14:05:00
 */
@Component
public class WorkTaskPictureRepository extends ServiceImpl<WorkTaskPictureMapper, WorkTaskPicture> {

  /**
   * 条件查询
   * @param workTaskPictureDto 条件
   */
  public List<WorkTaskPicture> findList(WorkTaskPictureDto workTaskPictureDto){
    return this.lambdaQuery()
         .in(WorkTaskPicture::getTaskId,workTaskPictureDto.getTaskIds())
        .eq(WorkTaskPicture::getTaskType,workTaskPictureDto.getTaskType())
        .list();
  }
}

