package com.biz.crm.sfa.business.work.task.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskObject;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskObjectDto;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 工作任务-执行对象(WorkTaskObject)service
 *
 * @author rentao
 * @since 2022-06-13 14:05:00
 */
public interface WorkTaskObjectService {

  /**
   * 分页查询
   *
   * @param pageable 分页参数
   * @param workTaskObject 分页条件
   */
  Page<WorkTaskObject> findByConditions(Pageable pageable, WorkTaskObject workTaskObject);

  /**
   * 条件查询
   *
   * @param workTaskObject 分页条件
   */
  List<WorkTaskObject> findList(WorkTaskObject workTaskObject);

  /**
   * 批量新增
   *
   * @param workTaskObjectDtos 新增参数
   */
  void createBatch(List<WorkTaskObjectDto> workTaskObjectDtos);

}
