package com.biz.crm.sfa.business.work.task.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskObject;
import com.biz.crm.sfa.business.work.task.local.repository.WorkTaskObjectRepository;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskObjectService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskObjectDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.Validate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import java.util.List;

/**
 * 工作任务-执行对象(WorkTaskObject)serviceImpl
 *
 * @author rentao
 * @since 2022-06-13 14:05:00
 */
@Service("workTaskObjectService")
public class WorkTaskObjectServiceImpl implements WorkTaskObjectService {

  @Autowired private WorkTaskObjectRepository workTaskObjectRepository;
  @Autowired private NebulaToolkitService nebulaToolkitService;

  /**
   * 分页查询
   *
   * @param pageable 分页参数
   * @param workTaskObject 分页条件
   */
  @Override
  public Page<WorkTaskObject> findByConditions(Pageable pageable, WorkTaskObject workTaskObject) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(workTaskObject)) {
      workTaskObject = new WorkTaskObject();
    }
    return this.workTaskObjectRepository.findByConditions(pageable, workTaskObject);
  }


  /**
   * 条件查询
   *
   * @param workTaskObject 分页条件
   */
  @Override
  public List<WorkTaskObject> findList(WorkTaskObject workTaskObject) {
    return this.workTaskObjectRepository.findList(workTaskObject);
  }

  /**
   * 批量新增
   *
   * @param workTaskObjectDtos 新增参数
   */
  @Override
  @Transactional
  public void createBatch(List<WorkTaskObjectDto> workTaskObjectDtos) {
    this.createValidate(workTaskObjectDtos);
    List<WorkTaskObject> workTaskObjects = (List<WorkTaskObject>) this.nebulaToolkitService.copyCollectionByWhiteList(workTaskObjectDtos, WorkTaskObjectDto.class, WorkTaskObject.class, HashSet.class, ArrayList.class);
    this.workTaskObjectRepository.saveBatch(workTaskObjects);
  }


  /**
   * 新增验证
   *
   * @param workTaskObjectDtos
   */
  private void createValidate(List<WorkTaskObjectDto> workTaskObjectDtos) {
    Validate.isTrue(!CollectionUtils.isEmpty(workTaskObjectDtos),"传入参数不能为空！");
    workTaskObjectDtos.forEach(workTaskObjectDto -> {
      Validate.notNull(workTaskObjectDto, "新增时，对象信息不能为空！");
      workTaskObjectDto.setId(null);
      Validate.notBlank(workTaskObjectDto.getTaskId(), "新增数据时,任务id不能为空!");
      Validate.notBlank(workTaskObjectDto.getCustomerCode(), "新增数据时,客户编码不能为空!");
      Validate.notBlank(workTaskObjectDto.getCustomerName(), "新增数据时,客户名称不能为空!");
      Validate.notBlank(workTaskObjectDto.getCustomerType(), "新增数据时,客户类型不能为空!");
      workTaskObjectDto.setTenantCode(TenantUtils.getTenantCode());
      workTaskObjectDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      workTaskObjectDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    });
  }

}
