package com.biz.crm.sfa.business.work.task.local.service.internal;

import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskPicture;
import com.biz.crm.sfa.business.work.task.local.repository.WorkTaskPictureRepository;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskPictureService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskPictureDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.Validate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import java.util.List;

/**
 * 工作计划相关照片(WorkTaskPicture)serviceImpl
 *
 * @author rentao
 * @since 2022-06-13 14:05:00
 */
@Service("workTaskPictureService")
public class WorkTaskPictureServiceImpl implements WorkTaskPictureService {

  @Autowired private WorkTaskPictureRepository workTaskPictureRepository;
  @Autowired private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void createBatch(List<WorkTaskPictureDto> workTaskPictureDtos) {
    this.createValidate(workTaskPictureDtos);
    List<WorkTaskPicture> workTaskPictures = (List<WorkTaskPicture>) this.nebulaToolkitService.copyCollectionByWhiteList(workTaskPictureDtos, WorkTaskPictureDto.class, WorkTaskPicture.class, HashSet.class, ArrayList.class);
    this.workTaskPictureRepository.saveBatch(workTaskPictures);
  }

  @Override
  public List<WorkTaskPicture> findList(WorkTaskPictureDto workTaskPictureDto) {
    return this.workTaskPictureRepository.findList(workTaskPictureDto);
  }

  /**
   * 新增验证
   *
   * @param workTaskPictureDtos
   */
  private void createValidate(List<WorkTaskPictureDto> workTaskPictureDtos) {
    Validate.isTrue(!CollectionUtils.isEmpty(workTaskPictureDtos), "新增工作计划相关照片时，数据为空");
    workTaskPictureDtos.forEach(
        workTaskPictureDto -> {
          Validate.notNull(workTaskPictureDto, "新增时，对象信息不能为空！");
          workTaskPictureDto.setId(null);
          Validate.notBlank(workTaskPictureDto.getFileCode(), "缺失文件唯一识别号");
          Validate.notBlank(workTaskPictureDto.getTaskId(), "任务id不能为空");
          workTaskPictureDto.setTenantCode(TenantUtils.getTenantCode());
        });
  }
}
