package com.biz.crm.sfa.business.work.task.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskObject;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskPicture;
import com.biz.crm.sfa.business.work.task.local.repository.WorkTaskReceveRepository;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskObjectService;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskPictureService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskPictureDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveQueryDto;
import com.biz.crm.sfa.business.work.task.sdk.enums.AttachmentBizTypeEnum;
import com.biz.crm.sfa.business.work.task.sdk.enums.SfaTaskStatusEnum;
import com.biz.crm.sfa.business.work.task.sdk.service.WorkTaskReceveVoService;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskPictureVo;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReceveVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @description: 工作任务接收vo service
 * @author: rentao
 * @date: 2022/6/15 10:38
 */
@Service
@Slf4j
public class WorkTaskReceveVoServiceImpl implements WorkTaskReceveVoService {

  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private WorkTaskReceveRepository workTaskReceveRepository;
  @Autowired
  private WorkTaskPictureService workTaskPictureService;
  @Autowired
  private WorkTaskObjectService workTaskObjectService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 分页查询(任务接收接口)
   * 查询登录人当前组织岗位下
   *
   * @param pageable          分页参数
   * @param workTaskReceveDto 分页条件
   */
  @Override
  public Page<WorkTaskReceveVo> findByConditions(Pageable pageable, WorkTaskReceveQueryDto workTaskReceveDto) {
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(workTaskReceveDto)) {
      workTaskReceveDto = new WorkTaskReceveQueryDto();
    }
    workTaskReceveDto.setReceverOrgCode(loginDetails.getOrgCode());
    workTaskReceveDto.setReceverPosCode(loginDetails.getPostCode());
    workTaskReceveDto.setReceverCode(loginDetails.getAccount());
    return this.workTaskReceveRepository.findVoByConditions(pageable, workTaskReceveDto);
  }

  @Override
  public WorkTaskReceveVo findDetailById(String id) {
    WorkTaskReceveVo workTaskReceveVo = this.workTaskReceveRepository.findDetailById(id);
    if (Objects.nonNull(workTaskReceveVo)) {
      WorkTaskPictureDto workTaskPictureDto = new WorkTaskPictureDto();
      workTaskPictureDto.setTaskIds(Collections.singletonList(workTaskReceveVo.getReceveId()));
      workTaskPictureDto.setTaskType(AttachmentBizTypeEnum.TASK_EXECUTE.getDictCode());
      //执行的照片
      List<WorkTaskPicture> list = this.workTaskPictureService.findList(workTaskPictureDto);
      workTaskPictureDto.setTaskIds(Collections.singletonList(workTaskReceveVo.getTaskId()));
      workTaskPictureDto.setTaskType(AttachmentBizTypeEnum.TASK_ADD.getDictCode());
      //发布时照片
      List<WorkTaskPicture> workTaskPictures = this.workTaskPictureService.findList(workTaskPictureDto);
      if (!CollectionUtils.isEmpty(list)) {
        List<WorkTaskPictureVo> workTaskPictureVos =
            (List<WorkTaskPictureVo>)
                this.nebulaToolkitService.copyCollectionByWhiteList(list, WorkTaskPicture.class, WorkTaskPictureVo.class, HashSet.class, ArrayList.class);
        workTaskReceveVo.setExecuteTaskPicList(workTaskPictureVos);
      }
      if (!CollectionUtils.isEmpty(workTaskPictures)) {
        List<WorkTaskPictureVo> workTaskPictureVos =
            (List<WorkTaskPictureVo>)
                this.nebulaToolkitService.copyCollectionByWhiteList(workTaskPictures, WorkTaskPicture.class, WorkTaskPictureVo.class, HashSet.class, ArrayList.class);
        workTaskReceveVo.setSendTaskPicList(workTaskPictureVos);
      }

      WorkTaskObject workTaskObject = new WorkTaskObject();
      workTaskObject.setTaskId(workTaskReceveVo.getTaskId());
      List<WorkTaskObject> workTaskObjects = this.workTaskObjectService.findList(workTaskObject);
      if (!CollectionUtils.isEmpty(workTaskObjects)) {
        String taskObjectsStr = workTaskObjects.stream().map(WorkTaskObject::getCustomerName).collect(Collectors.joining(";"));
        workTaskReceveVo.setTaskObjectsStr(taskObjectsStr);
      }
    }
    return workTaskReceveVo;
  }

  /**
   * 分页查询（登录人）工作任务当日完成接收和待执行任务
   * 查询登录人当前组织岗位下
   *
   * @param pageable               分页参数
   * @param workTaskReceveQueryDto 分页条件
   */
  @Override
  public Page<WorkTaskReceveVo> findDayPlan(Pageable pageable,
                                            WorkTaskReceveQueryDto workTaskReceveQueryDto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    String queryDate = null;
    if (Objects.nonNull(workTaskReceveQueryDto)) {
      queryDate = workTaskReceveQueryDto.getQueryDate();
    }
    WorkTaskReceveQueryDto workTaskReceveQueryDto1 = this.assembleDayPlan(queryDate);
    return this.workTaskReceveRepository.findDayPlan(pageable, workTaskReceveQueryDto1);
  }


  /**
   * 查询（登录人）工作任务当日完成接收和待执行任务
   * 查询登录人当前组织岗位下
   *
   * @param queryDate 分页条件
   */
  @Override
  public String findDayPlanProgress(String queryDate) {
    WorkTaskReceveQueryDto workTaskReceveQueryDto = this.assembleDayPlan(queryDate);
    List<WorkTaskReceveVo> dayPlanList = this.workTaskReceveRepository.findDayPlanList(workTaskReceveQueryDto);
    if (CollectionUtils.isEmpty(dayPlanList)) {
      return "0/0";
    } else {
      int size = dayPlanList.size();
      List<WorkTaskReceveVo> collect = dayPlanList.stream().filter(
          workTaskReceveVo -> SfaTaskStatusEnum.EXECUTE_LODING.getDictCode()
              .equals(workTaskReceveVo.getExecuteStatus())).collect(
          Collectors.toList());
      if (CollectionUtils.isEmpty(collect)) {
        return "0/" + size;
      } else {
        return collect.size() + "/" + size;
      }
    }
  }


  private WorkTaskReceveQueryDto assembleDayPlan(String queryDate) {
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    WorkTaskReceveQueryDto workTaskReceveQueryDto = new WorkTaskReceveQueryDto();
    workTaskReceveQueryDto.setReceverOrgCode(loginDetails.getOrgCode());
    workTaskReceveQueryDto.setReceverPosCode(loginDetails.getPostCode());
    workTaskReceveQueryDto.setReceverCode(loginDetails.getAccount());
    if (StringUtils.isBlank(queryDate)) {
      //拿到当日时间 开始时间结束时间
      workTaskReceveQueryDto.setQueryDateOne(getFirstday(new Date()));
      workTaskReceveQueryDto.setQueryDateTwo(getLastday(new Date()));
    } else {
      try {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date querytime = format.parse(queryDate);
        //拿到当日时间 开始时间结束时间
        workTaskReceveQueryDto.setQueryDateOne(getFirstday(querytime));
        workTaskReceveQueryDto.setQueryDateTwo(getLastday(querytime));
      } catch (ParseException e) {
        e.printStackTrace();
      }
    }
    return workTaskReceveQueryDto;
  }

  /**
   * 获取输入日期当天最早时间
   *
   * @param time
   * @author rentao
   * @date
   */
  public static Date getFirstday(Date time) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTime(time);
    calendar.set(Calendar.HOUR_OF_DAY, 0);
    calendar.set(Calendar.MINUTE, 0);
    calendar.set(Calendar.SECOND, 0);
    return calendar.getTime();
  }

  public static Date getLastday(Date time) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTime(time);
    calendar.set(Calendar.HOUR_OF_DAY, 23);
    calendar.set(Calendar.MINUTE, 59);
    calendar.set(Calendar.SECOND, 59);
    return calendar.getTime();
  }
}
