package com.biz.crm.sfa.business.work.task.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTaskPicture;
import com.biz.crm.sfa.business.work.task.local.repository.WorkTaskReceveRepository;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskPictureService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskPictureDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReportDto;
import com.biz.crm.sfa.business.work.task.sdk.enums.AttachmentBizTypeEnum;
import com.biz.crm.sfa.business.work.task.sdk.service.WorkTaskReportVoService;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;


/**
 * @description: 订单后台表
 * @author: rentao
 * @date: 2022/6/13 19:32
 */
@Service
@Slf4j
public class WorkTaskReportVoServiceImpl implements WorkTaskReportVoService {

  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private WorkTaskReceveRepository workTaskReceveRepository;
  @Autowired
  private WorkTaskPictureService workTaskPictureService;

  @Override
  public Page<WorkTaskReportVo> findByConditions(Pageable pageable, WorkTaskReportDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new WorkTaskReportDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<WorkTaskReportVo> entityPage = this.workTaskReceveRepository.findSfaWorkTaskReportList(pageable, dto);
    List<WorkTaskReportVo> records = entityPage.getRecords();
    if(!CollectionUtils.isEmpty(records)){
      records.forEach(data -> {
        WorkTaskPictureDto workTaskPictureDto = new WorkTaskPictureDto();
        workTaskPictureDto.setTaskIds(Collections.singletonList(data.getId()));
        workTaskPictureDto.setTaskType(AttachmentBizTypeEnum.TASK_EXECUTE.getDictCode());
        List<WorkTaskPicture> executePicUrlList = this.workTaskPictureService.findList(workTaskPictureDto);
        if (!CollectionUtils.isEmpty(executePicUrlList)) {
          data.setExecuteTaskPicList(executePicUrlList.stream().map(WorkTaskPicture::getFileCode).collect(Collectors.toList()));
        }
        workTaskPictureDto.setTaskIds(Collections.singletonList(data.getTaskId()));
        workTaskPictureDto.setTaskType(AttachmentBizTypeEnum.TASK_ADD.getDictCode());
        List<WorkTaskPicture> sendTaskPicList = this.workTaskPictureService.findList(workTaskPictureDto);
        if (!CollectionUtils.isEmpty(sendTaskPicList)) {
          data.setSendTaskPicList(sendTaskPicList.stream().map(WorkTaskPicture::getFileCode).collect(Collectors.toList()));
        }
      });
    }
    return entityPage;
  }

  @Override
  public WorkTaskReportVo findById(String id) {
    WorkTaskReportDto workTaskReportDto = new WorkTaskReportDto();
    workTaskReportDto.setId(id);
    List<WorkTaskReportVo> records = this.findByConditions(null, workTaskReportDto).getRecords();
    if (!CollectionUtils.isEmpty(records)){
      return records.get(0);
    }
    return null;
  }
}
