package com.biz.crm.sfa.business.work.task.local.service.internal;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.work.task.local.entity.WorkTask;
import com.biz.crm.sfa.business.work.task.local.repository.WorkTaskRepository;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskObjectService;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskPictureService;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskReceveService;
import com.biz.crm.sfa.business.work.task.local.service.WorkTaskService;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskObjectDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskPictureDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveDto;
import com.biz.crm.sfa.business.work.task.sdk.enums.AttachmentBizTypeEnum;
import com.biz.crm.sfa.business.work.task.sdk.enums.SfaTaskReleaseEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

/**
 * 工作计划发布表(WorkTask)serviceImpl
 *
 * @author rentao
 * @since 2022-06-13 14:04:55
 */
@Service("workTaskService")
public class WorkTaskServiceImpl implements WorkTaskService {

  @Autowired
  private WorkTaskRepository workTaskRepository;
  @Autowired
  private GenerateCodeService generateCodeService;
  @Autowired
  private WorkTaskReceveService workTaskReceveService;
  @Autowired
  private WorkTaskObjectService workTaskObjectService;
  @Autowired
  private WorkTaskPictureService workTaskPictureService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private LoginUserService loginUserService;

  /**
   * 新增
   *
   * @param workTaskDto 新增参数
   */
  @Transactional
  @Override
  public WorkTask create(WorkTaskDto workTaskDto) {
    //参数校验
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    this.createValidate(workTaskDto);
    List<WorkTaskReceveDto> reqVos = workTaskDto.getSfaStaffMessageReqVos();
    WorkTask entity = this.nebulaToolkitService.copyObjectByWhiteList(workTaskDto, WorkTask.class, HashSet.class, ArrayList.class);
    entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    entity.setCreatePosCode(loginDetails.getPostCode());
    entity.setCreatePosName(loginDetails.getPostName());
    entity.setCreateOrgCode(loginDetails.getOrgCode());
    entity.setCreateOrgName(loginDetails.getOrgName());
    entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    entity.setTaskStatus(SfaTaskReleaseEnum.WAIT_EXECUTE.getDictCode());
    entity.setProgress("0/" + (CollectionUtils.isEmpty(reqVos) ? "0" : reqVos.size()));
    entity.setTaskCode(generateCodeService.generateCode("xxx", 1).get(0));
    this.workTaskRepository.save(entity);
    //新增接收
    reqVos.forEach(workTaskReceveDto -> {
      workTaskReceveDto.setTaskId(entity.getId());
    });
    this.workTaskReceveService.createBatch(reqVos);
    //新增图片
    List<WorkTaskPictureDto> pictures = workTaskDto.getPictures();
    if (!CollectionUtils.isEmpty(pictures)) {
      pictures.forEach(workTaskPictureDto -> {
        workTaskPictureDto.setTaskId(entity.getId());
        workTaskPictureDto.setTaskType(AttachmentBizTypeEnum.TASK_ADD.getDictCode());
      });
      this.workTaskPictureService.createBatch(pictures);
    }
    //新增执行对象
    List<WorkTaskObjectDto> taskObjects = workTaskDto.getTaskObjects();
    if (!CollectionUtils.isEmpty(pictures)) {
      taskObjects.forEach(workTaskObjectDto -> {
        workTaskObjectDto.setTaskId(entity.getId());
      });
      this.workTaskObjectService.createBatch(taskObjects);
    }
    return entity;
  }

  @Override
  @Transactional
  public void updateProgressAndTaskStatusById(WorkTaskDto workTaskDto) {
    Validate.notNull(workTaskDto, "编辑进度和状态时，传入参数为空");
    Validate.notNull(workTaskDto.getId(), "编辑进度和状态时，传入主键为空");
    Validate.notNull(workTaskDto.getProgress(), "编辑进度和状态时，传入进度为空");
    Validate.notNull(workTaskDto.getTaskStatus(), "编辑进度和状态时，传入状态为空");
    this.workTaskRepository.updateProgressAndTaskStatusById(workTaskDto);
  }

  /**
   * 新增验证
   *
   * @param workTaskDto
   */
  private void createValidate(WorkTaskDto workTaskDto) {
    Validate.notNull(workTaskDto, "新增时，对象信息不能为空！");
    workTaskDto.setTenantCode(TenantUtils.getTenantCode());
    workTaskDto.setId(null);
    Validate.notBlank(workTaskDto.getContent(), "新增数据时,任务内容不能为空");
    Validate.notBlank(workTaskDto.getTaskTitle(), "新增数据时,任务名称不能为空");
    Validate.notNull(workTaskDto.getEndDate(), "新增数据时,任务结束时间不能为空");
    Date startDate = new Date();
    Validate.isTrue(workTaskDto.getEndDate().after(startDate), "结束时间不能小于当前时间");
    Validate.isTrue(!CollectionUtils.isEmpty(workTaskDto.getSfaStaffMessageReqVos()), "请指定任务执行人");
  }

}
