package com.biz.crm.sfa.business.work.task.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 工作任务(发布) Dto
 * @author: rentao
 * @date: 2022/6/13 15:38
 */
@Data
@ApiModel(value = "WorkTaskDto", description = "工作任务(发布) Dto")
public class WorkTaskDto extends TenantFlagOpDto {

  /** 任务标题 */
  @ApiModelProperty("任务标题")
  private String taskTitle;

  /** 任务编码 */
  @ApiModelProperty("任务编码")
  private String taskCode;

  /** 任务内容 */
  @ApiModelProperty("任务内容")
  private String content;

  /** 任务进度 */
  @ApiModelProperty("任务进度")
  private String progress;

  /** 任务状态 */
  @ApiModelProperty("任务状态")
  private String taskStatus;

  /** 开始时间 */
  @ApiModelProperty("开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startDate;

  /** 截至时间 */
  @ApiModelProperty("截至时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endDate;

  /** 地址 */
  @ApiModelProperty("地址")
  private String taskSite;

  /** 图片集合 */
  @ApiModelProperty("图片集合")
  private List<WorkTaskPictureDto> pictures;

  /** 执行对象集合 */
  @ApiModelProperty("执行对象集合")
  private List<WorkTaskObjectDto> taskObjects;

  /** 执行对象集合 */
  @ApiModelProperty("人员详情")
  private List<WorkTaskReceveDto> sfaStaffMessageReqVos;
}
