package com.biz.crm.sfa.business.work.task.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 工作任务(接收) Dto
 * @author: rentao
 * @date: 2022/6/13 15:41
 */
@Data
@ApiModel(value = "WorkTaskReceveDto", description = "工作任务(接收) Dto")
public class WorkTaskReceveDto extends TenantFlagOpDto {


  /** 任务id */
  @ApiModelProperty("任务id")
  private String taskId;

  /** 接收人姓名 */
  @ApiModelProperty("接收人姓名")
  private String receverName;

  /** 接收人账号 */
  @ApiModelProperty("接收人账号")
  private String receverCode;

  /** 接收人组织编码 */
  @ApiModelProperty("接收人组织编码")
  private String receverOrgCode;

  /** 接收人组织名称 */
  @ApiModelProperty("接收人组织名称")
  private String receverOrgName;

  /** 接收人职位编码 */
  @ApiModelProperty("接收人职位编码")
  private String receverPosCode;

  /** 接收人职位名称 */
  @ApiModelProperty("接收人职位编码")
  private String receverPosName;

  /** 接收时间 */
  @ApiModelProperty("接收时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date receveDate;

  /** 结束时间 */
  @ApiModelProperty("结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endDate;

  /** 执行时定位地址 */
  @ApiModelProperty("执行时定位地址")
  private String address;

  /** 执行总结 */
  @ApiModelProperty("执行总结")
  private String summary;

  /** 执行状态 */
  @ApiModelProperty("执行状态")
  private String executeStatus;

  /**照片 */
  @ApiModelProperty("照片")
  private List<WorkTaskPictureDto> executeTaskPicList;
}
