package com.biz.crm.sfa.business.work.task.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description:工作任务-接收查询Dto
 * @author: rentao
 * @date: 2022/6/15 10:49
 */
@Data
@ApiModel(value = "WorkTaskReceveQueryDto", description = "工作任务-接收查询Dto")
public class WorkTaskReceveQueryDto {

  @ApiModelProperty("接收人账号")
  private String receverCode;

  @ApiModelProperty("接收人组织编码")
  private String receverOrgCode;

  @ApiModelProperty("接收人岗位编码")
  private String receverPosCode;

  @ApiModelProperty("执行状态")
  private String executeStatus;

  @ApiModelProperty("关键字")
  private String keyWord;

  @ApiModelProperty("生效开始范围")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startDateOne;

  @ApiModelProperty("生效开始范围")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startDateTwo;

  @ApiModelProperty("截至开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date overDateOne;

  @ApiModelProperty("截至结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date overDateTwo;


  @ApiModelProperty("查询日期（接收） 分页查询（登录人）工作任务当日完成接收和待执行任务")
  private String queryDate;

  @ApiModelProperty("查询日期（当天开始时间）")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date queryDateOne;

  @ApiModelProperty("查询日期 （当天结束时间）分页查询（登录人）工作任务当日完成接收和待执行任务")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date queryDateTwo;

}
