package com.biz.crm.sfa.business.work.task.sdk.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * SFA 附件
 *
 * @author: luoqi @Date: 2021-4-7 15:57
 * @version: V1.0 @Description:
 */
public enum AttachmentBizTypeEnum {
  TASK_ADD("task_add", "task_add", "任务新增", "0"),
  TASK_EXECUTE("task_execute", "task_execute", "任务执行", "1");

  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;

  AttachmentBizTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /** 通过key获取 AttachmentBizTypeEnum */
  public static AttachmentBizTypeEnum getByKey(String key) {
    return Arrays.stream(AttachmentBizTypeEnum.values())
        .filter(item -> Objects.equals(item.getKey(), key))
        .findFirst()
        .orElse(null);
  }

  /** 通过dictCode获取 AttachmentBizTypeEnum */
  public static AttachmentBizTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(AttachmentBizTypeEnum.values())
        .filter(item -> Objects.equals(item.getKey(), dictCode))
        .findFirst()
        .orElse(null);
  }
}
