package com.biz.crm.sfa.business.work.task.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/** @Author hej @Created Date 2020-11-18 */
public enum SfaTaskReleaseEnum {

  // 0待执行 1部分完成 2已完成 3未完成 4已拒绝 5已过期
  WAIT_EXECUTE("0", "0", "待执行", "0"),
  PARTLY_COMPLETED("1", "1", "部分完成", "1"),
  EXECUTE_LODING("2", "2", "已完成", "2"),
  UNFINISHED("3", "3", "未完成", "2"),
  ALREADY_FINISH("4", "4", "已拒绝", "4"),
  PAST_DUE("5", "5", "已过期", "5");

  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;

  SfaTaskReleaseEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /** 通过key获取 SfaTaskReleaseEnum */
  public static SfaTaskReleaseEnum getByKey(String key) {
    return Arrays.stream(SfaTaskReleaseEnum.values())
        .filter(item -> Objects.equals(item.getKey(), key))
        .findFirst()
        .orElse(null);
  }

  /** 通过dictCode获取 SfaTaskReleaseEnum */
  public static SfaTaskReleaseEnum getByDictCode(String dictCode) {
    return Arrays.stream(SfaTaskReleaseEnum.values())
        .filter(item -> Objects.equals(item.getKey(), dictCode))
        .findFirst()
        .orElse(null);
  }
}
