package com.biz.crm.sfa.business.work.task.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveDto;
import com.biz.crm.sfa.business.work.task.sdk.dto.WorkTaskReceveQueryDto;
import com.biz.crm.sfa.business.work.task.sdk.vo.WorkTaskReceveVo;
import org.springframework.data.domain.Pageable;

/**
 * @description: 工作任务（接收）
 * @author: rentao
 * @date: 2022/6/15 10:37
 */
public interface WorkTaskReceveVoService {

  /**
   * 分页查询(任务接收接口)
   * 查询登录人当前组织岗位下
   * @param pageable 分页参数
   * @param workTaskReceveQueryDto 分页条件
   *
   */
  Page<WorkTaskReceveVo> findByConditions(Pageable pageable, WorkTaskReceveQueryDto workTaskReceveQueryDto);

  /**
   * id查询(任务接收详情)
   *
   *  @param id
   */
  WorkTaskReceveVo findDetailById(String id);


  /**
   * 分页查询（登录人）工作任务当日完成接收和待执行任务
   * 查询登录人当前组织岗位下
   * @param pageable 分页参数
   * @param workTaskReceveQueryDto 分页条件
   *
   */
  Page<WorkTaskReceveVo> findDayPlan(Pageable pageable, WorkTaskReceveQueryDto workTaskReceveQueryDto);

  /**
   * 查询（登录人）工作任务当日完成接收和待执行任务
   * 查询登录人当前组织岗位下
   * @param queryDate 分页条件
   *
   */
  String findDayPlanProgress(String queryDate);
}
