package com.biz.crm.sfa.business.work.task.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description:工作任务-发布查询Dto
 * @author: rentao
 * @date: 2022/6/15 10:49
 */
@Data
@ApiModel(value = "WorkTaskReceveQueryDto", description = "工作任务-发布查询Dto")
public class WorkTaskQueryDto extends TenantFlagOpDto {

  @ApiModelProperty("创建人岗位")
  @Column(name = "create_pos_code", length = 200, columnDefinition = "varchar(200) COMMENT '创建人岗位'")
  private String createPosCode;

  @ApiModelProperty("创建人组织")
  @Column(name = "create_org_code", length = 200, columnDefinition = "varchar(200) COMMENT '创建人组织'")
  private String createOrgCode;

  @ApiModelProperty("执行状态")
  private String taskStatus;

  @ApiModelProperty("关键字")
  private String keyWord;

  @ApiModelProperty("生效开始范围")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startDateOne;

  @ApiModelProperty("生效开始范围")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startDateTwo;

  @ApiModelProperty("截至开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date overDateOne;

  @ApiModelProperty("截至结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date overDateTwo;
}
