package com.biz.crm.sfa.business.work.task.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @description: 工作任务报表查询Dto
 * @author: rentao
 * @date: 2022/6/13 19:32
 */
@Data
@ApiModel(value = "WorkTaskReportDto", description = "工作任务报表查询Dto")
public class WorkTaskReportDto extends TenantFlagOpDto {

  @ApiModelProperty("任务编码")
  private String taskCode;

  @ApiModelProperty("任务标题")
  private String taskTitle;

  @ApiModelProperty("任务发送人")
  private String senderName;

  @ApiModelProperty("执行状态 0待执行 1已完成 2已回绝 3已过期")
  private String executeStatus;

  @ApiModelProperty("任务接收人")
  private String receverName;
}
