package com.biz.crm.sfa.business.work.task.sdk.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/** @Author hej @Created Date 2020-11-18 */
public enum SfaTaskStatusEnum {

  // 0待执行 1已完成 2已回绝 3已过期
  WAIT_EXECUTE("0", "0", "待执行", "0"),
  EXECUTE_LODING("1", "1", "已完成", "1"),
  ALREADY_FINISH("2", "2", "已回绝", "2"),
  PAST_DUE("3", "3", "已过期", "2");

  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;

  SfaTaskStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /** 通过key获取 SfaTaskStatusEnum */
  public static SfaTaskStatusEnum getByKey(String key) {
    return Arrays.stream(SfaTaskStatusEnum.values())
        .filter(item -> Objects.equals(item.getKey(), key))
        .findFirst()
        .orElse(null);
  }

  /** 通过dictCode获取 SfaTaskStatusEnum */
  public static SfaTaskStatusEnum getByDictCode(String dictCode) {
    return Arrays.stream(SfaTaskStatusEnum.values())
        .filter(item -> Objects.equals(item.getKey(), dictCode))
        .findFirst()
        .orElse(null);
  }
}
