package com.biz.crm.sfa.business.work.task.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 工作任务(接收) 返回vo
 * @author: rentao
 * @date: 2022/6/15 10:37
 */
@Data
@ApiModel(value = "工作任务(接收) ")
public class WorkTaskReceveVo extends UuidVo {

  @ApiModelProperty("id")
  private String receveId;

  @ApiModelProperty("照片列表(发布)")
  private List<WorkTaskPictureVo> sendTaskPicList;

  @ApiModelProperty("照片列表(执行)")
  private List<WorkTaskPictureVo> executeTaskPicList;

  @ApiModelProperty("执行状态 0待执行 1已完成 2已回绝 3已过期")
  private String executeStatus;

  @ApiModelProperty("任务接收人")
  private String receverName;

  @ApiModelProperty("接收人账号")
  private String receverCode;

  @ApiModelProperty("接收时间")
  @Column(name = "receve_date", length = 20, columnDefinition = "datetime COMMENT '接收时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date receveDate;

  @ApiModelProperty("任务接收地址")
  private String address;

  @ApiModelProperty("任务接收总结")
  private String summary;

  @ApiModelProperty("任务id")
  private String taskId;

  @ApiModelProperty("查看状态 0上级查看 1自身查看")
  private String checkStatus;

  @ApiModelProperty("接收时间")
  @Column(name = "receve_date", length = 20, columnDefinition = "datetime COMMENT '接收时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endDate;

  @ApiModelProperty("任务内容")
  private String content;

  @ApiModelProperty("任务发送人")
  private String senderName;

  @ApiModelProperty("任务标题")
  private String taskTitle;

  @ApiModelProperty("执行对象集合")
  private String taskObjectsStr;
}
