package com.biz.crm.sfa.business.work.task.sdk.vo;

import com.bizunited.nebula.common.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

/**
 * @description: 工作任务报表VO
 * @author: rentao
 * @date: 2022/6/13 19:31
 */
@Data
@ApiModel(value = "WorkTaskReportVo", description = "工作任务报表VO")
public class WorkTaskReportVo extends UuidVo {

  @ApiModelProperty("任务id")
  private String taskId;

  @ApiModelProperty("任务编码")
  private String taskCode;

  @ApiModelProperty("任务标题")
  private String taskTitle;

  @ApiModelProperty("执行时间")
  private String releaseDate;

  @ApiModelProperty("开始时间")
  private String startDate;

  @ApiModelProperty("截至时间")
  private String endDate;

  @ApiModelProperty("任务详情")
  private String content;

  @ApiModelProperty("任务发送人")
  private String senderName;

  @ApiModelProperty("任务发送人职位名称")
  private String senderPosName;

  @ApiModelProperty("任务发送人职位编码")
  private String senderPosCode;

  @ApiModelProperty("任务地点")
  private String taskSite;

  @ApiModelProperty("执行状态 0待执行 1已完成 2已回绝 3已过期")
  private String executeStatus;

  @ApiModelProperty("任务接收人")
  private String receverName;

  @ApiModelProperty("接收人账号")
  private String receverCode;

  @ApiModelProperty("任务接收时间（发布日期）")
  private String receveDate;

  @ApiModelProperty("执行是定位地址")
  private String address;

  @ApiModelProperty("任务接收总结")
  private String summary;

  @ApiModelProperty("接收人组织编码")
  private String receverOrgCode;

  @ApiModelProperty("接收人组织名称")
  private String receverOrgName;

  @ApiModelProperty("接收人职位编码")
  private String receverPosCode;

  @ApiModelProperty("接收人职位名称")
  private String receverPosName;

  @ApiModelProperty("任务状态 0待执行 1部分完成 2已完成 3未完成 4已拒绝 5已过期")
  private String taskStatus;

  @ApiModelProperty("任务发布照片集合")
  private List<String> sendTaskPicList;

  @ApiModelProperty("执行任务照片集合")
  private List<String> executeTaskPicList;

}
